"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleUpgradeTestProviders = RuleUpgradeTestProviders;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _styledComponents = require("styled-components");
var _reactQuery = require("@tanstack/react-query");
var _reactRedux = require("react-redux");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _reactRouterDom = require("react-router-dom");
var _discover_in_timeline_provider = require("../../../../../../../common/components/discover_in_timeline/mocks/discover_in_timeline_provider");
var _kibana_react = require("../../../../../../../common/lib/kibana/kibana_react.mock");
var _mock = require("../../../../../../../common/mock");
var _helpers = require("../../../../../../../common/utils/route/helpers");
var _rules_table_toolbar = require("../../../../../components/rules_table/rules_table_toolbar");
var _kibana = require("../../../../../../../common/lib/kibana");
var _ml_capabilities_provider = require("../../../../../../../common/components/ml/permissions/ml_capabilities_provider");
var _upselling_provider = require("../../../../../../../common/components/upselling_provider");
var _mock_assistant_provider = require("../../../../../../../common/mock/mock_assistant_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MockKibanaContextProvider = (0, _kibana_react.createKibanaContextProviderMock)();
function UpsellingProviderMock({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: (0, _kibana.useKibana)().services.upselling
  }, children);
}

/**
 * Defining custom Test Providers for Rule Upgrade Flyout required to avoid
 * impact on existing tests. Existing TestProviders doesn't provide necessary
 * contexts for the Rule Upgrade Flyout like `MlCapabilitiesProvider`. Mocking the
 * latter in TestProviders requires to refactor multiple Jest tests due to
 * `useKibana()` custom mocks also used in `MlCapabilitiesProvider`.
 */
function RuleUpgradeTestProviders({
  children
}) {
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    logger: {
      log: jest.fn(),
      warn: jest.fn(),
      error: () => {}
    }
  });
  const store = (0, _mock.createMockStore)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
    analytics: undefined
  }, /*#__PURE__*/_react.default.createElement(_helpers.RouterSpyStateContext.Provider, {
    value: [{
      pageName: _deeplinksSecurity.SecurityPageName.rules,
      detailName: undefined,
      tabName: _rules_table_toolbar.AllRulesTabs.updates,
      search: '',
      pathName: '/',
      state: undefined
    }, jest.fn()]
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, null, /*#__PURE__*/_react.default.createElement(MockKibanaContextProvider, null, /*#__PURE__*/_react.default.createElement(_ml_capabilities_provider.MlCapabilitiesProvider, null, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(UpsellingProviderMock, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiDarkVars,
      darkMode: true
    })
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProviderComponent, null, /*#__PURE__*/_react.default.createElement(_discover_in_timeline_provider.MockDiscoverInTimelineContext, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProvider, {
    highContrastMode: false
  }, children)))))))))))));
}