"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradePrebuiltRulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _constants = require("../constants");
var _rules_changelog_link = require("../rules_changelog_link");
var _upgrade_prebuilt_rules_table_buttons = require("./upgrade_prebuilt_rules_table_buttons");
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table_context");
var _upgrade_prebuilt_rules_table_filters = require("./upgrade_prebuilt_rules_table_filters");
var _use_upgrade_prebuilt_rules_table_columns = require("./use_upgrade_prebuilt_rules_table_columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_ITEMS_MESSAGE = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_RULES_AVAILABLE_FOR_UPGRADE),
  titleSize: "s",
  body: i18n.NO_RULES_AVAILABLE_FOR_UPGRADE_BODY,
  "data-test-subj": "noPrebuiltRulesAvailableForUpgrade"
});

/**
 * Table Component for displaying rules that have available updates
 */
const UpgradePrebuiltRulesTable = exports.UpgradePrebuiltRulesTable = /*#__PURE__*/_react.default.memo(() => {
  const {
    state: {
      ruleUpgradeStates,
      hasRulesToUpgrade,
      isLoading,
      isFetching,
      isRefetching,
      isUpgradingSecurityPackages,
      pagination,
      sortingOptions
    },
    actions: {
      setPagination,
      setSortingOptions
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  const [selected, setSelected] = (0, _react.useState)([]);
  const rulesColumns = (0, _use_upgrade_prebuilt_rules_table_columns.useUpgradePrebuiltRulesTableColumns)();
  const shouldShowProgress = isUpgradingSecurityPackages || isRefetching;
  const handleTableChange = (0, _react.useCallback)(({
    page: {
      index,
      size
    },
    sort
  }) => {
    setPagination({
      page: index + 1,
      perPage: size
    });
    if (sort) {
      setSortingOptions({
        field: sort.field,
        order: sort.direction
      });
    }
  }, [setPagination, setSortingOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)),
    loadedContent: !hasRulesToUpgrade ? NO_ITEMS_MESSAGE : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        alignSelf: 'start'
      }
    }, /*#__PURE__*/_react.default.createElement(_rules_changelog_link.RulesChangelogLink, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      gutterSize: "s",
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table_filters.UpgradePrebuiltRulesTableFilters, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table_buttons.UpgradePrebuiltRulesTableButtons, {
      selectedRules: selected
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      loading: isFetching,
      items: ruleUpgradeStates,
      pagination: {
        totalItemCount: pagination.total,
        pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS,
        pageIndex: pagination.page - 1,
        pageSize: pagination.perPage
      },
      selection: {
        selectable: () => true,
        onSelectionChange: setSelected,
        initialSelected: selected
      },
      sorting: {
        sort: {
          // EuiBasicTable has incorrect `sort.field` types which accept only `keyof Item` and reject fields in dot notation
          field: sortingOptions.field,
          direction: sortingOptions.order
        }
      },
      itemId: "rule_id",
      "data-test-subj": "rules-upgrades-table",
      columns: rulesColumns,
      onChange: handleTableChange
    }))
  }));
});
UpgradePrebuiltRulesTable.displayName = 'UpgradePrebuiltRulesTable';