"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRevertPrebuiltRule = exports.getRevertRuleErrorStatusCode = void 0;
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_revert_prebuilt_rule_mutation = require("../../api/hooks/prebuilt_rules/use_revert_prebuilt_rule_mutation");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRevertPrebuiltRule = () => {
  const {
    addError,
    addSuccess,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_revert_prebuilt_rule_mutation.useRevertPrebuiltRuleMutation)({
    onError: error => {
      addError(populateErrorStack(error), {
        title: i18n.RULE_REVERT_FAILED,
        toastMessage: getErrorToastMessage(error)
      });
    },
    onSuccess: result => {
      if (result.attributes.summary.total === result.attributes.summary.skipped) {
        addWarning(i18n.ALL_REVERT_RULES_SKIPPED(result.attributes.summary.skipped));
      }
      addSuccess(getSuccessToastMessage(result.attributes));
    }
  });
};
exports.useRevertPrebuiltRule = useRevertPrebuiltRule;
const populateErrorStack = error => {
  error.stack = JSON.stringify(error.body, null, 2);
  return error;
};
const getErrorToastMessage = error => {
  var _attributes$errors$at, _error$body, _error$body$attribute, _error$body$attribute2;
  const statusCode = getRevertRuleErrorStatusCode(error);
  if (statusCode === 409) {
    return i18n.RULE_REVERT_FAILED_CONCURRENCY_MESSAGE;
  }
  return (_attributes$errors$at = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$attribute = _error$body.attributes.errors) === null || _error$body$attribute === void 0 ? void 0 : (_error$body$attribute2 = _error$body$attribute.at(0)) === null || _error$body$attribute2 === void 0 ? void 0 : _error$body$attribute2.message) !== null && _attributes$errors$at !== void 0 ? _attributes$errors$at : '';
};
const getRevertRuleErrorStatusCode = error => {
  var _error$body2, _error$body2$attribut, _error$body2$attribut2;
  return (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : (_error$body2$attribut = _error$body2.attributes.errors) === null || _error$body2$attribut === void 0 ? void 0 : (_error$body2$attribut2 = _error$body2$attribut.at(0)) === null || _error$body2$attribut2 === void 0 ? void 0 : _error$body2$attribut2.status_code;
};
exports.getRevertRuleErrorStatusCode = getRevertRuleErrorStatusCode;
const getSuccessToastMessage = result => {
  const toastMessage = [];
  const {
    summary: {
      succeeded,
      skipped
    }
  } = result;
  if (succeeded > 0) {
    toastMessage.push(i18n.REVERT_RULE_SUCCESS(succeeded));
  }
  if (skipped > 0) {
    toastMessage.push(i18n.REVERT_RULE_SKIPPED(skipped));
  }
  return toastMessage.join(' ');
};