"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDownloadExportedRules = useDownloadExportedRules;
var _react = require("react");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _download_blob = require("../../../../common/utils/download_blob");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _helpers = require("../../../rule_management_ui/components/rules_table/helpers");
var _use_show_bulk_error_toast = require("./use_show_bulk_error_toast");
var _use_show_bulk_success_toast = require("./use_show_bulk_success_toast");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_EXPORT_FILENAME = `${i18n.EXPORT_FILENAME}.ndjson`;

/**
 * downloads exported rules, received from export action
 */
function useDownloadExportedRules() {
  const showBulkSuccessToast = (0, _use_show_bulk_success_toast.useShowBulkSuccessToast)();
  const showBulkErrorToast = (0, _use_show_bulk_error_toast.useShowBulkErrorToast)();
  return (0, _react.useCallback)(async response => {
    try {
      (0, _download_blob.downloadBlob)(response, DEFAULT_EXPORT_FILENAME);
      showBulkSuccessToast({
        actionType: _rule_management.BulkActionTypeEnum.export,
        summary: await (0, _helpers.getExportedRulesCounts)(response)
      });
    } catch (error) {
      showBulkErrorToast({
        actionType: _rule_management.BulkActionTypeEnum.export,
        error
      });
    }
  }, [showBulkSuccessToast, showBulkErrorToast]);
}