"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleScheduleReadOnly = RuleScheduleReadOnly;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _to_simple_rule_schedule = require("../../../../../../../../../common/api/detection_engine/model/rule_schema/to_simple_rule_schedule");
var i18n = _interopRequireWildcard(require("../../../../translations"));
var _rule_schedule_section = require("../../../../rule_schedule_section");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuleScheduleReadOnly({
  ruleSchedule
}) {
  const simpleRuleSchedule = (0, _react.useMemo)(() => (0, _to_simple_rule_schedule.toSimpleRuleSchedule)(ruleSchedule), [ruleSchedule]);
  if (simpleRuleSchedule) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: [{
        title: i18n.INTERVAL_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_rule_schedule_section.AccessibleTimeValue, {
          timeValue: simpleRuleSchedule.interval
        })
      }, {
        title: i18n.LOOK_BACK_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_rule_schedule_section.AccessibleTimeValue, {
          timeValue: simpleRuleSchedule.lookback
        })
      }]
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: i18n.INTERVAL_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_rule_schedule_section.AccessibleTimeValue, {
        timeValue: ruleSchedule.interval
      })
    }, {
      title: i18n.RULE_SOURCE_EVENTS_TIME_RANGE_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement("span", null, i18n.RULE_SOURCE_EVENTS_TIME_RANGE(ruleSchedule.from, ruleSchedule.to))
    }]
  });
}