"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlQueryEditAdapter = EsqlQueryEditAdapter;
var _react = _interopRequireDefault(require("react"));
var _esql_query_edit = require("../../../../../../../rule_creation/components/esql_query_edit");
var _use_diffable_rule_data_view = require("../hooks/use_diffable_rule_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EsqlQueryEditAdapter({
  finalDiffableRule
}) {
  const {
    dataView,
    isLoading
  } = (0, _use_diffable_rule_data_view.useDiffableRuleDataView)(finalDiffableRule);
  return /*#__PURE__*/_react.default.createElement(_esql_query_edit.EsqlQueryEdit, {
    path: "esqlQuery",
    required: true,
    dataView: dataView !== null && dataView !== void 0 ? dataView : DEFAULT_DATA_VIEW_BASE,
    loading: isLoading,
    disabled: isLoading
  });
}
const DEFAULT_DATA_VIEW_BASE = {
  title: '',
  fields: []
};