"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_FIELD_ORDER = exports.SETUP_UPGRADE_FIELD_ORDER = exports.SCHEDULE_UPGRADE_FIELD_ORDER = exports.LARGE_DESCRIPTION_LIST_COLUMN_WIDTHS = exports.DEFINITION_UPGRADE_FIELD_ORDER = exports.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS = exports.ABOUT_UPGRADE_FIELD_ORDER = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS = exports.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS = ['50%', '50%'];
const LARGE_DESCRIPTION_LIST_COLUMN_WIDTHS = exports.LARGE_DESCRIPTION_LIST_COLUMN_WIDTHS = ['30%', '70%'];
const ABOUT_UPGRADE_FIELD_ORDER = exports.ABOUT_UPGRADE_FIELD_ORDER = ['version', 'name', 'description', 'building_block', 'investigation_fields', 'severity', 'severity_mapping', 'risk_score', 'risk_score_mapping', 'references', 'false_positives', 'rule_name_override', 'threat', 'threat_indicator_path', 'timestamp_override', 'tags'];
const DEFINITION_UPGRADE_FIELD_ORDER = exports.DEFINITION_UPGRADE_FIELD_ORDER = ['data_source', 'type', 'kql_query', 'eql_query', 'esql_query', 'anomaly_threshold', 'machine_learning_job_id', 'related_integrations', 'required_fields', 'timeline_template', 'threshold', 'threat_index', 'threat_mapping', 'threat_query', 'threat_indicator_path', 'new_terms_fields', 'history_window_start', 'max_signals', 'alert_suppression'];
const SCHEDULE_UPGRADE_FIELD_ORDER = exports.SCHEDULE_UPGRADE_FIELD_ORDER = ['rule_schedule'];
const SETUP_UPGRADE_FIELD_ORDER = exports.SETUP_UPGRADE_FIELD_ORDER = ['setup', 'note'];

/**
 * This order is derived from a combination of the Rule Details Flyout display order
 * and the `DiffableRule` type that is returned from the rule diff API endpoint
 */
const UPGRADE_FIELD_ORDER = exports.UPGRADE_FIELD_ORDER = [
// Rule About fields
...ABOUT_UPGRADE_FIELD_ORDER,
// Rule Definition fields
...DEFINITION_UPGRADE_FIELD_ORDER,
// Rule Schedule fields
...SCHEDULE_UPGRADE_FIELD_ORDER,
// Rule Setup fields
...SETUP_UPGRADE_FIELD_ORDER];