"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANUAL_RULE_RUN_TIME_RANGE_TITLE = exports.MANUAL_RULE_RUN_START_DATE_OUT_OF_RANGE_ERROR = exports.MANUAL_RULE_RUN_START_AT_TITLE = exports.MANUAL_RULE_RUN_NOTIFIACTIONS_LIMITATIONS = exports.MANUAL_RULE_RUN_MODAL_TITLE = exports.MANUAL_RULE_RUN_INVALID_TIME_RANGE_ERROR = exports.MANUAL_RULE_RUN_FUTURE_TIME_RANGE_ERROR = exports.MANUAL_RULE_RUN_END_AT_TITLE = exports.MANUAL_RULE_RUN_CONFIRM_BUTTON = exports.MANUAL_RULE_RUN_CANCEL_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MANUAL_RULE_RUN_MODAL_TITLE = exports.MANUAL_RULE_RUN_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.modalTitle', {
  defaultMessage: 'Manual rule run'
});
const MANUAL_RULE_RUN_TIME_RANGE_TITLE = exports.MANUAL_RULE_RUN_TIME_RANGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.timeRangeTitle', {
  defaultMessage: 'Select timerange for manual rule run'
});
const MANUAL_RULE_RUN_START_AT_TITLE = exports.MANUAL_RULE_RUN_START_AT_TITLE = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.startAtTitle', {
  defaultMessage: 'Start at'
});
const MANUAL_RULE_RUN_END_AT_TITLE = exports.MANUAL_RULE_RUN_END_AT_TITLE = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.endAtTitle', {
  defaultMessage: 'Finish at'
});
const MANUAL_RULE_RUN_CONFIRM_BUTTON = exports.MANUAL_RULE_RUN_CONFIRM_BUTTON = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.confirmButton', {
  defaultMessage: 'Run'
});
const MANUAL_RULE_RUN_CANCEL_BUTTON = exports.MANUAL_RULE_RUN_CANCEL_BUTTON = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.cancelButton', {
  defaultMessage: 'Cancel'
});
const MANUAL_RULE_RUN_INVALID_TIME_RANGE_ERROR = exports.MANUAL_RULE_RUN_INVALID_TIME_RANGE_ERROR = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.invalidTimeRangeError', {
  defaultMessage: 'Selected time range is invalid'
});
const MANUAL_RULE_RUN_FUTURE_TIME_RANGE_ERROR = exports.MANUAL_RULE_RUN_FUTURE_TIME_RANGE_ERROR = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.futureTimeRangeError', {
  defaultMessage: 'Manual rule run cannot be scheduled for the future'
});
const MANUAL_RULE_RUN_START_DATE_OUT_OF_RANGE_ERROR = maxDaysLookback => _i18n.i18n.translate('xpack.securitySolution.manuelRulaRun.startDateIsOutOfRangeError', {
  values: {
    maxDaysLookback
  },
  defaultMessage: 'Manual rule run cannot be scheduled earlier than {maxDaysLookback, plural, =1 {# day} other {# days}} ago'
});
exports.MANUAL_RULE_RUN_START_DATE_OUT_OF_RANGE_ERROR = MANUAL_RULE_RUN_START_DATE_OUT_OF_RANGE_ERROR;
const MANUAL_RULE_RUN_NOTIFIACTIONS_LIMITATIONS = exports.MANUAL_RULE_RUN_NOTIFIACTIONS_LIMITATIONS = _i18n.i18n.translate('xpack.securitySolution.manualRuleRun.notificationsLimitations', {
  defaultMessage: 'Alert summary rule actions that run at a custom frequency are not performed during manual rule runs.'
});