"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryRequiredValidatorFactory = queryRequiredValidatorFactory;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _utils = require("../../../../common/detection_engine/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EQL_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.eqlQueryFieldRequiredError', {
  defaultMessage: 'An EQL query is required.'
});
const ESQL_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.ruleManagement.ruleCreation.validation.query.esqlQueryFieldRequiredError', {
  defaultMessage: 'An ES|QL query is required.'
});
const CUSTOM_QUERY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customQueryFieldRequiredError', {
  defaultMessage: 'A custom query is required.'
});
function queryRequiredValidatorFactory(ruleType) {
  return (...args) => {
    const [{
      path,
      value
    }] = args;
    const validationError = {
      code: 'ERR_FIELD_MISSING',
      path
    };
    if (!(0, _lodash.isEmpty)(value.query.query)) {
      return;
    }
    if ((0, _utils.isEqlRule)(ruleType)) {
      return {
        ...validationError,
        message: EQL_REQUIRED
      };
    }
    if ((0, _utils.isEsqlRule)(ruleType)) {
      return {
        ...validationError,
        message: ESQL_REQUIRED
      };
    }
    if ((0, _lodash.isEmpty)(value.filters)) {
      return {
        ...validationError,
        message: CUSTOM_QUERY_REQUIRED
      };
    }
  };
}