"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistentNewTermsState = usePersistentNewTermsState;
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _utils = require("../../../../../common/detection_engine/utils");
var _shared_imports = require("../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePersistentNewTermsState({
  form,
  ruleTypePath,
  newTermsFieldsPath,
  historyWindowStartPath
}) {
  const lastNewTermsState = (0, _react.useRef)();
  const [formData] = (0, _shared_imports.useFormData)({
    form,
    watch: [newTermsFieldsPath, historyWindowStartPath]
  });
  const {
    [ruleTypePath]: ruleType,
    [newTermsFieldsPath]: newTermsFields,
    [historyWindowStartPath]: historyWindowStart
  } = formData;
  const previousRuleType = (0, _usePrevious.default)(ruleType);
  (0, _react.useEffect)(() => {
    if ((0, _utils.isNewTermsRule)(ruleType) && !(0, _utils.isNewTermsRule)(previousRuleType) && lastNewTermsState.current) {
      form.updateFieldValues({
        [newTermsFieldsPath]: lastNewTermsState.current.newTermsFields,
        [historyWindowStartPath]: lastNewTermsState.current.historyWindowStart
      });
      return;
    }
    if ((0, _utils.isNewTermsRule)(ruleType)) {
      lastNewTermsState.current = {
        newTermsFields,
        historyWindowStart
      };
    }
  }, [form, ruleType, previousRuleType, newTermsFieldsPath, historyWindowStartPath, newTermsFields, historyWindowStart]);
}