"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectRuleType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_esql_availability = require("../../../../common/hooks/esql/use_esql_availability");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _utils = require("../../../../../common/detection_engine/utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _ml_card_description = require("./ml_card_description");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectRuleType = exports.SelectRuleType = /*#__PURE__*/(0, _react.memo)(({
  describedByIds = [],
  field,
  isUpdateView,
  hasValidLicense,
  isMlAdmin
}) => {
  const ruleType = field.value;
  const setType = (0, _react.useCallback)(type => {
    field.setValue(type);
  }, [field]);
  const setEql = (0, _react.useCallback)(() => setType('eql'), [setType]);
  const setMl = (0, _react.useCallback)(() => setType('machine_learning'), [setType]);
  const setQuery = (0, _react.useCallback)(() => setType('query'), [setType]);
  const setThreshold = (0, _react.useCallback)(() => setType('threshold'), [setType]);
  const setThreatMatch = (0, _react.useCallback)(() => setType('threat_match'), [setType]);
  const setNewTerms = (0, _react.useCallback)(() => setType('new_terms'), [setType]);
  const setEsql = (0, _react.useCallback)(() => setType('esql'), [setType]);
  const {
    isEsqlRuleTypeEnabled
  } = (0, _use_esql_availability.useEsqlAvailability)();
  const eqlSelectableConfig = (0, _react.useMemo)(() => ({
    onClick: setEql,
    isSelected: (0, _utils.isEqlRule)(ruleType)
  }), [ruleType, setEql]);
  const querySelectableConfig = (0, _react.useMemo)(() => ({
    onClick: setQuery,
    isSelected: (0, _utils.isQueryRule)(ruleType)
  }), [ruleType, setQuery]);
  const mlSelectableConfig = (0, _react.useMemo)(() => ({
    isDisabled: !hasValidLicense || !isMlAdmin,
    onClick: setMl,
    isSelected: (0, _helpers.isMlRule)(ruleType)
  }), [ruleType, setMl, hasValidLicense, isMlAdmin]);
  const thresholdSelectableConfig = (0, _react.useMemo)(() => ({
    onClick: setThreshold,
    isSelected: (0, _utils.isThresholdRule)(ruleType)
  }), [ruleType, setThreshold]);
  const threatMatchSelectableConfig = (0, _react.useMemo)(() => ({
    onClick: setThreatMatch,
    isSelected: (0, _utils.isThreatMatchRule)(ruleType)
  }), [ruleType, setThreatMatch]);
  const newTermsSelectableConfig = (0, _react.useMemo)(() => ({
    onClick: setNewTerms,
    isSelected: (0, _utils.isNewTermsRule)(ruleType)
  }), [ruleType, setNewTerms]);
  const esqlSelectableConfig = (0, _react.useMemo)(() => ({
    onClick: setEsql,
    isSelected: (0, _utils.isEsqlRule)(ruleType)
  }), [ruleType, setEsql]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "selectRuleType",
    describedByIds: describedByIds,
    label: field.label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, (!isUpdateView || querySelectableConfig.isSelected) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "customRuleType",
    title: i18n.QUERY_TYPE_TITLE,
    titleSize: "xs",
    description: i18n.QUERY_TYPE_DESCRIPTION,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "search"
    }),
    selectable: querySelectableConfig,
    layout: "horizontal"
  })), (!isUpdateView || mlSelectableConfig.isSelected) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "machineLearningRuleType",
    title: i18n.ML_TYPE_TITLE,
    titleSize: "xs",
    description: /*#__PURE__*/_react.default.createElement(_ml_card_description.MlCardDescription, {
      hasValidLicense: hasValidLicense
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "machineLearningApp"
    }),
    isDisabled: mlSelectableConfig.isDisabled && !mlSelectableConfig.isSelected,
    selectable: mlSelectableConfig,
    layout: "horizontal"
  })), (!isUpdateView || thresholdSelectableConfig.isSelected) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "thresholdRuleType",
    title: i18n.THRESHOLD_TYPE_TITLE,
    titleSize: "xs",
    description: i18n.THRESHOLD_TYPE_DESCRIPTION,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "indexFlush"
    }),
    selectable: thresholdSelectableConfig,
    layout: "horizontal"
  })), (!isUpdateView || eqlSelectableConfig.isSelected) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "eqlRuleType",
    title: i18n.EQL_TYPE_TITLE,
    titleSize: "xs",
    description: i18n.EQL_TYPE_DESCRIPTION,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "eql"
    }),
    selectable: eqlSelectableConfig,
    layout: "horizontal"
  })), (!isUpdateView || threatMatchSelectableConfig.isSelected) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "threatMatchRuleType",
    title: i18n.THREAT_MATCH_TYPE_TITLE,
    titleSize: "xs",
    description: i18n.THREAT_MATCH_TYPE_DESCRIPTION,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "list"
    }),
    selectable: threatMatchSelectableConfig,
    layout: "horizontal"
  })), (!isUpdateView || newTermsSelectableConfig.isSelected) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "newTermsRuleType",
    title: i18n.NEW_TERMS_TYPE_TITLE,
    titleSize: "xs",
    description: i18n.NEW_TERMS_TYPE_DESCRIPTION,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "magnifyWithPlus"
    }),
    selectable: newTermsSelectableConfig,
    layout: "horizontal"
  })), (!isUpdateView && isEsqlRuleTypeEnabled || esqlSelectableConfig.isSelected) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "esqlRuleType",
    title: i18n.ESQL_TYPE_TITLE,
    titleSize: "xs",
    description: i18n.ESQL_TYPE_DESCRIPTION,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElasticsearch",
      size: "l"
    }),
    selectable: esqlSelectableConfig,
    layout: "horizontal"
  }))));
});
SelectRuleType.displayName = 'SelectRuleType';