"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdEdit = ThresholdEdit;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _threshold_input = require("../../../rule_creation_ui/components/threshold_input");
var _field_configs = require("./field_configs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ThresholdEdit({
  path,
  esFields
}) {
  const aggregatableFields = (0, _react.useMemo)(() => esFields.filter(field => field.aggregatable === true), [esFields]);
  const ThresholdInputChildren = (0, _react.useCallback)(({
    thresholdField,
    thresholdValue,
    thresholdCardinalityField,
    thresholdCardinalityValue
  }) => /*#__PURE__*/_react.default.createElement(_threshold_input.ThresholdInput, {
    browserFields: aggregatableFields,
    thresholdField: thresholdField,
    thresholdValue: thresholdValue,
    thresholdCardinalityField: thresholdCardinalityField,
    thresholdCardinalityValue: thresholdCardinalityValue
  }), [aggregatableFields]);
  const cardinalityFieldConfig = (0, _react.useMemo)(() => (0, _field_configs.getCardinalityFieldConfig)(path), [path]);
  const cardinalityValueConfig = (0, _react.useMemo)(() => (0, _field_configs.getCardinalityValueConfig)(path), [path]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      thresholdField: {
        path: `${path}.field`,
        config: _field_configs.THRESHOLD_FIELD_CONFIG
      },
      thresholdValue: {
        path: `${path}.value`,
        config: _field_configs.THRESHOLD_VALUE_CONFIG
      },
      thresholdCardinalityField: {
        path: `${path}.cardinality.field`,
        config: cardinalityFieldConfig
      },
      thresholdCardinalityValue: {
        path: `${path}.cardinality.value`,
        config: cardinalityValueConfig
      }
    }
  }, ThresholdInputChildren);
}