"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedIntegrations = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _related_integrations_help_info = require("./related_integrations_help_info");
var _related_integration_field_row = require("./related_integration_field_row");
var i18n = _interopRequireWildcard(require("./translations"));
var _optional_field_label = require("../optional_field_label");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RelatedIntegrationsComponent({
  path,
  dataTestSubj
}) {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseArray, {
    path: path,
    initialNumberOfItems: 0
  }, ({
    items,
    addItem,
    removeItem,
    form
  }) => /*#__PURE__*/_react.default.createElement(RelatedIntegrationsList, {
    items: items,
    addItem: addItem,
    removeItem: removeItem,
    path: path,
    form: form,
    dataTestSubj: dataTestSubj
  }));
}
const RelatedIntegrationsList = ({
  items,
  addItem,
  removeItem,
  path,
  form,
  dataTestSubj
}) => {
  const flattenedFieldNames = (0, _utils.getFlattenedArrayFieldNames)(form, path);

  /*
    Not using "watch" for the initial render, to let row components render and initialize form fields.
    Then we can use the "watch" feature to track their changes.
  */
  const hasRenderedInitially = flattenedFieldNames.length > 0;
  const fieldsToWatch = hasRenderedInitially ? flattenedFieldNames : [];
  const [formData] = (0, _shared_imports.useFormData)({
    watch: fieldsToWatch
  });
  const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.RELATED_INTEGRATIONS_LABEL, /*#__PURE__*/_react.default.createElement(_related_integrations_help_info.RelatedIntegrationsHelpInfo, null));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    labelType: "legend",
    fullWidth: true,
    "data-test-subj": dataTestSubj,
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, items.map(item => {
    var _formData$path;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: item.id,
      "data-test-subj": "relatedIntegrationRow"
    }, /*#__PURE__*/_react.default.createElement(_related_integration_field_row.RelatedIntegrationFieldRow, {
      item: item,
      relatedIntegrations: (_formData$path = formData[path]) !== null && _formData$path !== void 0 ? _formData$path : [],
      removeItem: removeItem
    }));
  })), items.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "plusInCircle",
    onClick: addItem
  }, i18n.ADD_INTEGRATION)));
};
const RelatedIntegrations = exports.RelatedIntegrations = /*#__PURE__*/_react.default.memo(RelatedIntegrationsComponent);