"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryBarFooter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _errors_popover = require("./errors_popover");
var _eql_overview_link = require("./eql_overview_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  border-radius: 0;
  border-bottom-left-radius: 6px;
  border-bottom-right-radius: 6px;
  background: ${({
  theme
}) => theme.eui.euiColorLightestShade};
  padding: ${({
  theme
}) => theme.eui.euiSizeXS} ${({
  theme
}) => theme.eui.euiSizeS};
`;
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-height: ${({
  theme
}) => theme.eui.euiSizeXL};
`;
const FlexItemLeftBorder = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const FlexItemWithMarginRight = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const Spinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  margin: 0 ${({
  theme
}) => theme.eui.euiSizeS};
`;
const singleSelection = {
  asPlainText: true
};
const EqlQueryBarFooter = ({
  errors,
  isLoading,
  isSizeOptionDisabled,
  dataView,
  eqlOptions,
  onEqlOptionsChange
}) => {
  var _eqlOptions$size;
  const [openEqlSettings, setIsOpenEqlSettings] = (0, _react.useState)(false);
  const [localSize, setLocalSize] = (0, _react.useState)((_eqlOptions$size = eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.size) !== null && _eqlOptions$size !== void 0 ? _eqlOptions$size : 100);
  const debounceSize = (0, _react.useRef)();
  const {
    keywordFields,
    nonDateFields,
    dateFields
  } = (0, _react.useMemo)(() => (0, _lodash.isEmpty)(dataView === null || dataView === void 0 ? void 0 : dataView.fields) ? {
    keywordFields: [],
    dateFields: [],
    nonDateFields: []
  } : {
    keywordFields: dataView.fields.filter(f => {
      var _f$esTypes;
      return (_f$esTypes = f.esTypes) === null || _f$esTypes === void 0 ? void 0 : _f$esTypes.includes('keyword');
    }).map(f => ({
      label: f.name
    })),
    dateFields: dataView.fields.filter(f => f.type === 'date').map(f => ({
      label: f.name
    })),
    nonDateFields: dataView.fields.filter(f => f.type !== 'date').map(f => ({
      label: f.name
    }))
  }, [dataView]);
  const openEqlSettingsHandler = (0, _react.useCallback)(() => {
    setIsOpenEqlSettings(true);
  }, []);
  const closeEqlSettingsHandler = (0, _react.useCallback)(() => {
    setIsOpenEqlSettings(false);
  }, []);
  const handleEventCategoryField = (0, _react.useCallback)(opt => {
    if (onEqlOptionsChange) {
      if (opt.length > 0) {
        onEqlOptionsChange('eventCategoryField', opt[0].label);
      } else {
        onEqlOptionsChange('eventCategoryField', undefined);
      }
    }
  }, [onEqlOptionsChange]);
  const handleTiebreakerField = (0, _react.useCallback)(opt => {
    if (onEqlOptionsChange) {
      if (opt.length > 0) {
        onEqlOptionsChange('tiebreakerField', opt[0].label);
      } else {
        onEqlOptionsChange('tiebreakerField', undefined);
      }
    }
  }, [onEqlOptionsChange]);
  const handleTimestampField = (0, _react.useCallback)(opt => {
    if (onEqlOptionsChange) {
      if (opt.length > 0) {
        onEqlOptionsChange('timestampField', opt[0].label);
      } else {
        onEqlOptionsChange('timestampField', undefined);
      }
    }
  }, [onEqlOptionsChange]);
  const handleSizeField = (0, _react.useCallback)(evt => {
    if (onEqlOptionsChange) {
      var _evt$target, _debounceSize$current, _evt$target2;
      setLocalSize(evt === null || evt === void 0 ? void 0 : (_evt$target = evt.target) === null || _evt$target === void 0 ? void 0 : _evt$target.valueAsNumber);
      if ((_debounceSize$current = debounceSize.current) !== null && _debounceSize$current !== void 0 && _debounceSize$current.cancel) {
        var _debounceSize$current2;
        (_debounceSize$current2 = debounceSize.current) === null || _debounceSize$current2 === void 0 ? void 0 : _debounceSize$current2.cancel();
      }
      debounceSize.current = (0, _lodash.debounce)(newSize => onEqlOptionsChange('size', newSize), 800);
      debounceSize.current(evt === null || evt === void 0 ? void 0 : (_evt$target2 = evt.target) === null || _evt$target2 === void 0 ? void 0 : _evt$target2.valueAsNumber);
    }
  }, [onEqlOptionsChange]);
  const eventCategoryField = (0, _react.useMemo)(() => (eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.eventCategoryField) != null ? [{
    label: eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.eventCategoryField
  }] : undefined, [eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.eventCategoryField]);
  const tiebreakerField = (0, _react.useMemo)(() => (eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.tiebreakerField) != null ? [{
    label: eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.tiebreakerField
  }] : undefined, [eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.tiebreakerField]);
  const timestampField = (0, _react.useMemo)(() => (eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.timestampField) != null ? [{
    label: eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.timestampField
  }] : undefined, [eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.timestampField]);
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(FlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, errors.length > 0 && /*#__PURE__*/_react.default.createElement(_errors_popover.ErrorsPopover, {
    ariaLabel: i18n.EQL_VALIDATION_ERROR_POPOVER_LABEL,
    errors: errors
  }), isLoading && /*#__PURE__*/_react.default.createElement(Spinner, {
    "data-test-subj": "eql-validation-loading",
    size: "m"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    alignItems: "center",
    responsive: false
  }, !onEqlOptionsChange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eql_overview_link.EqlOverviewLink, null)), onEqlOptionsChange && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlexItemWithMarginRight, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eql_overview_link.EqlOverviewLink, null)), /*#__PURE__*/_react.default.createElement(FlexItemLeftBorder, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: openEqlSettingsHandler,
      iconType: "controlsVertical",
      isDisabled: openEqlSettings,
      "aria-label": "eql settings",
      "data-test-subj": "eql-settings-trigger"
    }),
    isOpen: openEqlSettings,
    closePopover: closeEqlSettingsHandler,
    anchorPosition: "downCenter",
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, i18n.EQL_SETTINGS_TITLE), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, !isSizeOptionDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-size-field",
    label: i18n.EQL_OPTIONS_SIZE_LABEL,
    helpText: i18n.EQL_OPTIONS_SIZE_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: localSize,
    onChange: handleSizeField,
    min: 1,
    max: 10000
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-event-category-field",
    label: i18n.EQL_OPTIONS_EVENT_CATEGORY_FIELD_LABEL,
    helpText: i18n.EQL_OPTIONS_EVENT_CATEGORY_FIELD_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: keywordFields,
    selectedOptions: eventCategoryField,
    singleSelection: singleSelection,
    onChange: handleEventCategoryField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-tiebreaker-field",
    label: i18n.EQL_OPTIONS_EVENT_TIEBREAKER_FIELD_LABEL,
    helpText: i18n.EQL_OPTIONS_EVENT_TIEBREAKER_FIELD_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: nonDateFields,
    selectedOptions: tiebreakerField,
    singleSelection: singleSelection,
    onChange: handleTiebreakerField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-timestamp-field",
    label: i18n.EQL_OPTIONS_EVENT_TIMESTAMP_FIELD_LABEL,
    helpText: i18n.EQL_OPTIONS_EVENT_TIMESTAMP_FIELD_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: dateFields,
    selectedOptions: timestampField,
    singleSelection: singleSelection,
    onChange: handleTimestampField
  }))))))))));
};
exports.EqlQueryBarFooter = EqlQueryBarFooter;