"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AISettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
var _use_space_id = require("../../common/hooks/use_space_id");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AISettings = () => {
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const {
    application: {
      navigateToApp,
      capabilities: {
        securitySolutionAssistant: {
          'ai-assistant': securityAIAssistantEnabled
        }
      }
    },
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const spaceId = (0, _use_space_id.useSpaceId)();
  const onTabChange = (0, _react.useCallback)(tab => {
    navigateTo({
      deepLinkId: _constants.SecurityPageName.configurationsAiSettings,
      path: `?tab=${tab}`
    });
  }, [navigateTo]);
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const currentTab = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = searchParams.get('tab')) !== null && _ref !== void 0 ? _ref : _elasticAssistant.CONVERSATIONS_TAB;
  }, [searchParams]);
  if (!securityAIAssistantEnabled) {
    navigateToApp('home');
  }
  return spaceId ? /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantSpaceIdProvider, {
    spaceId: spaceId
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.SearchAILakeConfigurationsSettingsManagement, {
    dataViews: dataViews,
    onTabChange: onTabChange,
    currentTab: currentTab
  })) : null;
};
exports.AISettings = AISettings;