"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineTimeRangeSelector = exports.timelineQueryByIdSelectorFactory = exports.timelineQueryByIdSelector = exports.timelineQueriesFactory = exports.timelineFullScreenSelector = exports.socTrendsTimeRangeSelector = exports.inputsSelector = exports.globalTimeRangeSelector = exports.globalSelector = exports.globalSavedQuerySelector = exports.globalQuerySelector = exports.globalQueryByIdSelector = exports.globalQuery = exports.globalFullScreenSelector = exports.globalFiltersQuerySelector = exports.getTimelineSelector = exports.getTimelinePolicySelector = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuery = {
  id: 'kql',
  inspect: null,
  isInspected: false,
  loading: false,
  refetch: null,
  selectedInspectIndex: 0,
  searchSessionId: undefined
};
const selectInputs = state => state.inputs;
const selectGlobal = state => state.inputs.global;
const selectTimeline = state => state.inputs.timeline;

// TODO: remove undefined when socTrendsEnabled feature flag removed
const selectSocTrends = state => state.inputs.socTrends;
const selectGlobalQuery = (state, id) => state.inputs.global.queries.find(q => q.id === id) || defaultQuery;
const inputsSelector = () => (0, _reselect.createSelector)(selectInputs, inputs => inputs);
exports.inputsSelector = inputsSelector;
const timelineTimeRangeSelector = exports.timelineTimeRangeSelector = (0, _reselect.createSelector)(selectTimeline, timeline => timeline.timerange);

// TODO: remove ? when socTrendsEnabled feature flag removed
const socTrendsTimeRangeSelector = exports.socTrendsTimeRangeSelector = (0, _reselect.createSelector)(selectSocTrends, socTrends => socTrends === null || socTrends === void 0 ? void 0 : socTrends.timerange);
const globalFullScreenSelector = exports.globalFullScreenSelector = (0, _reselect.createSelector)(selectGlobal, global => global.fullScreen);
const timelineFullScreenSelector = exports.timelineFullScreenSelector = (0, _reselect.createSelector)(selectTimeline, timeline => timeline.fullScreen);
const globalTimeRangeSelector = exports.globalTimeRangeSelector = (0, _reselect.createSelector)(selectGlobal, global => global.timerange);
const globalQuery = () => (0, _reselect.createSelector)(selectGlobal, global => global.queries);
exports.globalQuery = globalQuery;
const globalQueryByIdSelector = () => (0, _reselect.createSelector)(selectGlobalQuery, query => query);
exports.globalQueryByIdSelector = globalQueryByIdSelector;
const timelineQueryByIdSelector = exports.timelineQueryByIdSelector = (0, _reselect.createSelector)([selectInputs, (_state, id) => id], (inputs, id) => inputs.timeline.queries.find(q => q.id === id) || inputs.global.queries.find(q => q.id === id) || defaultQuery);
const timelineQueryByIdSelectorFactory = () => (0, _reselect.createSelector)(timelineQueryByIdSelector, query => query);
exports.timelineQueryByIdSelectorFactory = timelineQueryByIdSelectorFactory;
const timelineQueriesFactory = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline.queries);
exports.timelineQueriesFactory = timelineQueriesFactory;
const globalSelector = () => (0, _reselect.createSelector)(selectGlobal, global => global);
exports.globalSelector = globalSelector;
const DEFAULT_QUERY = {
  query: '',
  language: 'kuery'
};
const globalQuerySelector = () => (0, _reselect.createSelector)(selectGlobal, global => global.query || DEFAULT_QUERY);
exports.globalQuerySelector = globalQuerySelector;
const globalSavedQuerySelector = () => (0, _reselect.createSelector)(selectGlobal, global => global.savedQuery || null);
exports.globalSavedQuerySelector = globalSavedQuerySelector;
const NO_FILTERS = [];
const globalFiltersQuerySelector = () => (0, _reselect.createSelector)(selectGlobal, global => global.filters || NO_FILTERS);
exports.globalFiltersQuerySelector = globalFiltersQuerySelector;
const getTimelineSelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline);
exports.getTimelineSelector = getTimelineSelector;
const getTimelinePolicySelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline.policy);
exports.getTimelinePolicySelector = getTimelinePolicySelector;