"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRootNavLink = exports.useNavLinks = exports.formatNavigationLinks = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _application_links_updater = require("../../app/links/application_links_updater");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated use `applicationLinks` instead
 * This is going to be cleaned when the classic navigation is removed
 */
const formatNavigationLinks = appLinks => appLinks.map(link => {
  var _link$links;
  return {
    id: link.id,
    title: link.title,
    ...(link.categories != null && {
      categories: link.categories
    }),
    ...(link.description != null && {
      description: link.description
    }),
    ...(link.sideNavDisabled === true && {
      disabled: true
    }),
    ...(link.landingIcon != null && {
      landingIcon: link.landingIcon
    }),
    ...(link.landingImage != null && {
      landingImage: link.landingImage
    }),
    ...(link.sideNavIcon != null && {
      sideNavIcon: link.sideNavIcon
    }),
    ...(link.sideNavFooter != null && {
      isFooterLink: link.sideNavFooter
    }),
    ...(link.skipUrlState != null && {
      skipUrlState: link.skipUrlState
    }),
    ...(link.isBeta != null && {
      isBeta: link.isBeta
    }),
    ...(link.betaOptions != null && {
      betaOptions: link.betaOptions
    }),
    ...(((_link$links = link.links) === null || _link$links === void 0 ? void 0 : _link$links.length) && {
      links: formatNavigationLinks(link.links)
    })
  };
});
exports.formatNavigationLinks = formatNavigationLinks;
const navLinks$ = _application_links_updater.applicationLinksUpdater.links$.pipe((0, _rxjs.map)(formatNavigationLinks));

/**
 * @deprecated use `applicationLinks` instead
 * This is going to be cleaned when the classic navigation is removed
 */
const useNavLinks = () => {
  return (0, _useObservable.default)(navLinks$, []); // use default value from updater subject to prevent re-renderings
};

/**
 * @deprecated use `applicationLinks` instead
 * This is going to be cleaned when the classic navigation is removed
 */
exports.useNavLinks = useNavLinks;
const useRootNavLink = linkId => {
  return useNavLinks().find(({
    id
  }) => id === linkId);
};
exports.useRootNavLink = useRootNavLink;