"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateGetAIConnectors = exports.useAIConnectors = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _use_app_toasts = require("./use_app_toasts");
var _ai_connectors = require("../utils/connectors/ai_connectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY = ['ai_connectors'];
const useAIConnectors = () => {
  const {
    services: {
      http
    }
  } = (0, _kibana.useKibana)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    data,
    isLoading,
    error
  } = (0, _reactQuery.useQuery)({
    queryKey: QUERY_KEY,
    queryFn: () => (0, _ai_connectors.loadAiConnectors)(http),
    onError: err => {
      addError(err, {
        title: i18n.ERROR_FETCH_AI_CONNECTORS
      });
    },
    refetchOnWindowFocus: false
  });
  return (0, _react.useMemo)(() => ({
    aiConnectors: data !== null && data !== void 0 ? data : [],
    isLoading,
    error
  }), [data, isLoading, error]);
};
exports.useAIConnectors = useAIConnectors;
const useInvalidateGetAIConnectors = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(QUERY_KEY);
  }, [queryClient]);
};
exports.useInvalidateGetAIConnectors = useInvalidateGetAIConnectors;