"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserRelatedHosts = void 0;
var _react = require("react");
var _related_entities = require("../../../../../common/search_strategy/security_solution/related_entities");
var _use_search_strategy = require("../../use_search_strategy");
var _translations = require("./translations");
var _use_risk_engine_status = require("../../../../entity_analytics/api/hooks/use_risk_engine_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUserRelatedHosts = ({
  userName,
  indexNames,
  from,
  skip = false
}) => {
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _related_entities.RelatedEntitiesQueries.relatedHosts,
    initialResult: {
      totalCount: 0,
      relatedHosts: []
    },
    errorMessage: _translations.FAIL_RELATED_HOSTS,
    abort: skip
  });
  const {
    installed: isNewRiskScoreModuleInstalled,
    isLoading: riskScoreStatusLoading
  } = (0, _use_risk_engine_status.useIsNewRiskScoreModuleInstalled)();
  const userRelatedHostsResponse = (0, _react.useMemo)(() => ({
    inspect,
    totalCount: response.totalCount,
    relatedHosts: response.relatedHosts,
    refetch,
    loading
  }), [inspect, refetch, response.totalCount, response.relatedHosts, loading]);
  const userRelatedHostsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _related_entities.RelatedEntitiesQueries.relatedHosts,
    userName,
    from,
    isNewRiskScoreModuleInstalled
  }), [indexNames, from, userName, isNewRiskScoreModuleInstalled]);
  (0, _react.useEffect)(() => {
    if (!skip && !riskScoreStatusLoading) {
      search(userRelatedHostsRequest);
    }
  }, [userRelatedHostsRequest, search, skip, riskScoreStatusLoading]);
  return userRelatedHostsResponse;
};
exports.useUserRelatedHosts = useUserRelatedHosts;