"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryToggle = exports.getUniqueStorageKey = void 0;
var _react = require("react");
var _kibana = require("../../lib/kibana");
var _use_route_spy = require("../../utils/route/use_route_spy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUniqueStorageKey = (pageName, id) => id && pageName.length > 0 ? `kibana.siem:${id}.query.toggle:${pageName}` : null;
exports.getUniqueStorageKey = getUniqueStorageKey;
const useQueryToggle = id => {
  var _storage$get;
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const {
    services: {
      storage
    }
  } = (0, _kibana.useKibana)();
  const storageKey = getUniqueStorageKey(pageName, id);
  const [storageValue, setStorageValue] = (0, _react.useState)(storageKey != null ? (_storage$get = storage.get(storageKey)) !== null && _storage$get !== void 0 ? _storage$get : true : true);
  (0, _react.useEffect)(() => {
    if (storageKey != null) {
      var _storage$get2;
      setStorageValue((_storage$get2 = storage.get(storageKey)) !== null && _storage$get2 !== void 0 ? _storage$get2 : true);
    }
  }, [storage, storageKey]);
  const setToggleStatus = (0, _react.useCallback)(isOpen => {
    if (storageKey != null) {
      storage.set(storageKey, isOpen);
      setStorageValue(isOpen);
    }
  }, [storage, storageKey]);
  return id ? {
    toggleStatus: storageValue,
    setToggleStatus
  } : {
    toggleStatus: true,
    setToggleStatus: () => {}
  };
};
exports.useQueryToggle = useQueryToggle;