"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensAttributes = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _constants = require("../../../../common/constants");
var _types = require("../../../explore/network/pages/navigation/types");
var _containers = require("../../../sourcerer/containers");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
var _model = require("../../../sourcerer/store/model");
var _use_route_spy = require("../../utils/route/use_route_spy");
var _utils = require("./utils");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _use_selected_patterns = require("../../../data_view_manager/hooks/use_selected_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensAttributes = ({
  applyGlobalQueriesAndFilters = true,
  applyPageAndTabsFilters = true,
  extraOptions,
  getLensAttributes,
  lensAttributes,
  scopeId = _model.SourcererScopeName.default,
  stackByField,
  title
}) => {
  var _experimentalDataView, _experimentalDataView2, _attrs$state$adHocDat, _attrs$state;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    selectedPatterns: oldSelectedPatterns,
    dataViewId: oldDataViewId,
    indicesExist: oldIndicesExist
  } = (0, _containers.useSourcererDataView)(scopeId);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(scopeId);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(scopeId);
  const dataViewId = newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : '' : oldDataViewId;
  const indicesExist = newDataViewPickerEnabled ? !!((_experimentalDataView2 = experimentalDataView.matchedIndices) !== null && _experimentalDataView2 !== void 0 && _experimentalDataView2.length) : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const [{
    detailName,
    pageName,
    tabName
  }] = (0, _use_route_spy.useRouteSpy)();
  const tabsFilters = (0, _react.useMemo)(() => {
    if (tabName === _types.NetworkRouteType.events) {
      if (pageName === _constants.SecurityPageName.network) {
        return _utils.sourceOrDestinationIpExistsFilter;
      }
      return (0, _utils.fieldNameExistsFilter)(pageName);
    }
    return [];
  }, [pageName, tabName]);
  const pageFilters = (0, _react.useMemo)(() => {
    if ([_constants.SecurityPageName.hosts, _constants.SecurityPageName.users].indexOf(pageName) >= 0 && detailName != null) {
      return (0, _utils.getDetailsPageFilter)(pageName, detailName);
    }
    if (_constants.SecurityPageName.network === pageName) {
      return (0, _utils.getNetworkDetailsPageFilter)(detailName);
    }
    return [];
  }, [detailName, pageName]);
  const attrs = (0, _react.useMemo)(() => lensAttributes !== null && lensAttributes !== void 0 ? lensAttributes : getLensAttributes && stackByField !== null && getLensAttributes({
    stackByField,
    euiTheme,
    extraOptions
  }), [euiTheme, extraOptions, getLensAttributes, lensAttributes, stackByField]);
  const hasAdHocDataViews = Object.values((_attrs$state$adHocDat = attrs === null || attrs === void 0 ? void 0 : (_attrs$state = attrs.state) === null || _attrs$state === void 0 ? void 0 : _attrs$state.adHocDataViews) !== null && _attrs$state$adHocDat !== void 0 ? _attrs$state$adHocDat : {}).length > 0;
  const lensAttrsWithInjectedData = (0, _react.useMemo)(() => {
    var _attrs$references;
    if (lensAttributes == null && (getLensAttributes == null || stackByField === null || (stackByField === null || stackByField === void 0 ? void 0 : stackByField.length) === 0)) {
      return null;
    }
    const indexFilters = hasAdHocDataViews ? [] : (0, _utils.getIndexFilters)(selectedPatterns);
    return {
      ...attrs,
      ...(title != null ? {
        title
      } : {}),
      state: {
        ...attrs.state,
        ...(applyGlobalQueriesAndFilters ? {
          query
        } : {}),
        filters: [...attrs.state.filters, ...(applyPageAndTabsFilters ? pageFilters : []), ...(applyPageAndTabsFilters ? tabsFilters : []), ...indexFilters, ...(applyGlobalQueriesAndFilters ? filters : [])]
      },
      references: attrs === null || attrs === void 0 ? void 0 : (_attrs$references = attrs.references) === null || _attrs$references === void 0 ? void 0 : _attrs$references.map(ref => ({
        ...ref,
        id: dataViewId
      }))
    };
  }, [applyGlobalQueriesAndFilters, applyPageAndTabsFilters, attrs, dataViewId, filters, getLensAttributes, hasAdHocDataViews, lensAttributes, pageFilters, query, selectedPatterns, stackByField, tabsFilters, title]);
  return hasAdHocDataViews || !hasAdHocDataViews && indicesExist ? lensAttrsWithInjectedData : null;
};
exports.useLensAttributes = useLensAttributes;