"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.histogramDateTimeFormatter = exports.getDaysDiff = void 0;
exports.showErrorToast = showErrorToast;
exports.useThrottledResizeObserver = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _polyfilled = _interopRequireDefault(require("use-resize-observer/polyfilled"));
var _charts = require("@elastic/charts");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDaysDiff = (minDate, maxDate) => {
  const diff = maxDate.diff(minDate, 'days');
  if (diff <= 1 && !minDate.isSame(maxDate)) {
    return 2; // to return proper pattern from niceTimeFormatByDay
  }
  return diff;
};
exports.getDaysDiff = getDaysDiff;
const histogramDateTimeFormatter = (domain, fixedDiff) => {
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const diff = fixedDiff !== null && fixedDiff !== void 0 ? fixedDiff : getDaysDiff((0, _momentTimezone.default)(domain[0]), (0, _momentTimezone.default)(domain[1]));
  const format = (0, _charts.niceTimeFormatByDay)(diff);
  return (0, _charts.timeFormatter)(format);
};
exports.histogramDateTimeFormatter = histogramDateTimeFormatter;
const useThrottledResizeObserver = (wait = 100) => {
  const [size, setSize] = (0, _react.useState)({
    width: 0,
    height: 0
  });
  const onResize = (0, _react.useMemo)(() => (0, _fp.throttle)(wait, setSize), [wait]);
  const {
    ref
  } = (0, _polyfilled.default)({
    onResize
  });
  return {
    ref,
    ...size
  };
};

/**
 * Displays an error toast with a specified title and a short message.
 * Also allows to set a detailed message that will appear in the modal when user clicks the "See full error" button.
 *
 * @param title The title of the toast notification. Appears in both the toast header and the modal header.
 * @param shortMessage An optional short message. Appears under toast header.
 * @param fullMessage The full error message. Appears in the modal when user clicks the "See full error" button.
 * @param toasts The toasts service instance.
 */
exports.useThrottledResizeObserver = useThrottledResizeObserver;
function showErrorToast({
  title,
  shortMessage,
  fullMessage,
  toasts
}) {
  const error = new Error('Error details');
  error.stack = fullMessage;
  toasts.addError(error, {
    title,
    // Fall back to a space to ensure that the toast component does not render its default message
    toastMessage: shortMessage !== null && shortMessage !== void 0 ? shortMessage : ' '
  });
}