"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexItemWithLabel = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-top: 20px;
  text-align: center;
`;
const FlexItemWithoutLabel = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  text-align: center;
`;
const EntryItem = ({
  entry,
  indexPattern,
  threatIndexPatterns,
  showLabel,
  onChange
}) => {
  const handleFieldChange = (0, _react.useCallback)(([newField]) => {
    const {
      updatedEntry,
      index
    } = (0, _helpers.getEntryOnFieldChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleThreatFieldChange = (0, _react.useCallback)(([newField]) => {
    const {
      updatedEntry,
      index
    } = (0, _helpers.getEntryOnThreatFieldChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const renderFieldInput = (0, _react.useMemo)(() => {
    var _entry$field;
    const comboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      position: "top",
      content: (_entry$field = entry.field) === null || _entry$field === void 0 ? void 0 : _entry$field.name
    }, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.EsFieldSelector, {
      placeholder: i18n.FIELD_PLACEHOLDER,
      indexPattern: indexPattern,
      selectedField: entry.field,
      isClearable: false,
      isLoading: false,
      isDisabled: indexPattern == null,
      onChange: handleFieldChange,
      "data-test-subj": "entryField"
    }));
    if (showLabel) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: i18n.FIELD,
        "data-test-subj": "entryItemFieldInputFormRow"
      }, comboBox);
    } else {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: '',
        "data-test-subj": "entryItemFieldInputFormRow"
      }, comboBox);
    }
  }, [handleFieldChange, indexPattern, entry, showLabel]);
  const renderThreatFieldInput = (0, _react.useMemo)(() => {
    var _entry$value;
    const comboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      position: "top",
      content: (_entry$value = entry.value) === null || _entry$value === void 0 ? void 0 : _entry$value.name
    }, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.EsFieldSelector, {
      placeholder: i18n.FIELD_PLACEHOLDER,
      indexPattern: threatIndexPatterns,
      selectedField: entry.value,
      isClearable: false,
      isLoading: false,
      isDisabled: threatIndexPatterns == null,
      onChange: handleThreatFieldChange,
      "data-test-subj": "threatEntryField"
    }));
    if (showLabel) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: i18n.THREAT_FIELD,
        "data-test-subj": "threatFieldInputFormRow"
      }, comboBox);
    } else {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: '',
        "data-test-subj": "threatFieldInputFormRow"
      }, comboBox);
    }
  }, [handleThreatFieldChange, threatIndexPatterns, entry, showLabel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceAround",
    "data-test-subj": "itemEntryContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, renderFieldInput), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    alignItems: "center"
  }, showLabel ? /*#__PURE__*/_react.default.createElement(FlexItemWithLabel, {
    grow: false
  }, i18n.MATCHES) : /*#__PURE__*/_react.default.createElement(FlexItemWithoutLabel, {
    grow: false
  }, i18n.MATCHES))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, renderThreatFieldInput));
};
exports.EntryItem = EntryItem;
EntryItem.displayName = 'EntryItem';