"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Subtitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
    .siemSubtitle__item {
      color: ${theme.eui.euiTextSubduedColor};
      font-size: ${theme.eui.euiFontSizeXS};
      line-height: ${theme.eui.euiLineHeight};

      @media only screen and (min-width: ${theme.eui.euiBreakpoints.s}) {
        display: inline-block;
        margin-right: ${theme.eui.euiSize};

        &:last-child {
          margin-right: 0;
        }
      }
    }
  `}
`;
Wrapper.displayName = 'Wrapper';
const SubtitleItem = /*#__PURE__*/_react.default.memo(({
  children,
  dataTestSubj = 'header-panel-subtitle'
}) => {
  if (typeof children === 'string') {
    return /*#__PURE__*/_react.default.createElement("p", {
      className: "siemSubtitle__item siemSubtitle__item--text",
      "data-test-subj": dataTestSubj
    }, children);
  } else {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "siemSubtitle__item siemSubtitle__item--node",
      "data-test-subj": dataTestSubj
    }, children);
  }
});
SubtitleItem.displayName = 'SubtitleItem';
const Subtitle = exports.Subtitle = /*#__PURE__*/_react.default.memo(({
  items,
  ...props
}) => {
  const {
    'data-test-subj': dataTestSubj = 'subtitle'
  } = props;
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    "data-test-subj": dataTestSubj,
    className: "siemSubtitle"
  }, Array.isArray(items) ? items.map((item, i) => /*#__PURE__*/_react.default.createElement(SubtitleItem, {
    key: i
  }, item)) : /*#__PURE__*/_react.default.createElement(SubtitleItem, null, items));
});
Subtitle.displayName = 'Subtitle';