"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverItemsWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  width: 100%;
`;
const PopoverWrapper = (0, _styledComponents.default)(_eui.EuiBadgeGroup)`
  max-height: 200px;
  max-width: 600px;
  overflow: auto;
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
`;

/**
 * Component to render list of items in popover, wicth configurabe number of display items by default
 * @param items - array of items to render
 * @param renderItem - render function that render item, arguments: item, index, items[]
 * @param popoverTitle - title of popover
 * @param popoverButtonTitle - title of popover button that triggers popover
 * @param popoverButtonIcon - icon of popover button that triggers popover
 * @param numberOfItemsToDisplay - number of items to render that are no in popover, defaults to 0
 * @param dataTestPrefix - data-test-subj prefix to apply to elements
 */
const PopoverItemsComponent = ({
  items,
  renderItem,
  popoverTitle,
  popoverButtonTitle,
  popoverButtonIcon,
  numberOfItemsToDisplay = 0,
  dataTestPrefix = 'items'
}) => {
  const [isExceptionOverflowPopoverOpen, setIsExceptionOverflowPopoverOpen] = (0, _react.useState)(false);
  const OverflowList = ({
    items: itemsToRender
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, itemsToRender.map(renderItem));
  if (items.length <= numberOfItemsToDisplay) {
    return /*#__PURE__*/_react.default.createElement(PopoverItemsWrapper, {
      "data-test-subj": dataTestPrefix,
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(OverflowList, {
      items: items
    }));
  }
  return /*#__PURE__*/_react.default.createElement(PopoverItemsWrapper, {
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": dataTestPrefix
  }, numberOfItemsToDisplay !== 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(OverflowList, {
    items: items.slice(0, numberOfItemsToDisplay)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    "data-test-subj": `${dataTestPrefix}DisplayPopover`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: popoverButtonIcon,
      color: "hollow",
      "data-test-subj": `${dataTestPrefix}DisplayPopoverButton`,
      onClick: () => setIsExceptionOverflowPopoverOpen(!isExceptionOverflowPopoverOpen),
      onClickAriaLabel: popoverButtonTitle
    }, popoverButtonTitle),
    isOpen: isExceptionOverflowPopoverOpen,
    closePopover: () => setIsExceptionOverflowPopoverOpen(!isExceptionOverflowPopoverOpen),
    repositionOnScroll: true
  }, popoverTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": `${dataTestPrefix}DisplayPopoverTitle`
  }, popoverTitle) : null, /*#__PURE__*/_react.default.createElement(PopoverWrapper, {
    "data-test-subj": `${dataTestPrefix}DisplayPopoverWrapper`
  }, /*#__PURE__*/_react.default.createElement(OverflowList, {
    items: items.slice(numberOfItemsToDisplay)
  }))));
};
const MemoizedPopoverItems = /*#__PURE__*/_react.default.memo(PopoverItemsComponent);
MemoizedPopoverItems.displayName = 'PopoverItems';
const PopoverItems = exports.PopoverItems = MemoizedPopoverItems;