"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSwitchComponent = exports.JobSwitch = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../../../../common/machine_learning/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StaticSwitch = (0, _styledComponents.default)(_eui.EuiSwitch)`
  .euiSwitch__thumb,
  .euiSwitch__icon {
    transition: none;
  }
`;
StaticSwitch.displayName = 'StaticSwitch';
const JobSwitchComponent = ({
  job,
  isSecurityJobsLoading,
  onJobStateChange
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const handleChange = (0, _react.useCallback)(async e => {
    setIsLoading(true);
    await onJobStateChange(job, job.latestTimestampMs || 0, e.target.checked);
    setIsLoading(false);
  }, [job, setIsLoading, onJobStateChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isSecurityJobsLoading || isLoading || (0, _helpers.isJobLoading)(job.jobState, job.datafeedState) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "job-switch-loader"
  }) : /*#__PURE__*/_react.default.createElement(StaticSwitch, {
    "data-test-subj": "job-switch",
    disabled: (0, _helpers.isJobFailed)(job.jobState, job.datafeedState),
    checked: (0, _helpers.isJobStarted)(job.jobState, job.datafeedState),
    onChange: handleChange,
    showLabel: false,
    label: ""
  })));
};
exports.JobSwitchComponent = JobSwitchComponent;
JobSwitchComponent.displayName = 'JobSwitchComponent';
const JobSwitch = exports.JobSwitch = /*#__PURE__*/_react.default.memo(JobSwitchComponent);
JobSwitch.displayName = 'JobSwitch';