"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobIdFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobIdFilter = ({
  selectedJobIds,
  onSelect,
  title,
  jobIds,
  jobNameById
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const updateSelection = (0, _react.useCallback)(selectedJobId => {
    const currentSelection = selectedJobIds !== null && selectedJobIds !== void 0 ? selectedJobIds : [];
    const newSelection = currentSelection.includes(selectedJobId) ? currentSelection.filter(s => s !== selectedJobId) : [...currentSelection, selectedJobId];
    onSelect(newSelection);
  }, [selectedJobIds, onSelect]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    disabled: jobIds.length === 0,
    "data-test-subj": "job-id-filter-button",
    hasActiveFilters: selectedJobIds.length > 0,
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    numActiveFilters: selectedJobIds.length,
    onClick: onButtonClick,
    contentProps: {
      style: {
        minWidth: 112
      }
    } // avoid resizing when selecting job id
  }, title), [jobIds.length, selectedJobIds.length, isPopoverOpen, onButtonClick, title]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, jobIds.map(id => {
    var _jobNameById$id;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      "data-test-subj": `job-id-filter-item-${id}`,
      checked: selectedJobIds.includes(id) ? 'on' : undefined,
      key: id,
      onClick: () => updateSelection(id)
    }, (_jobNameById$id = jobNameById[id]) !== null && _jobNameById$id !== void 0 ? _jobNameById$id : id);
  }))));
};
exports.JobIdFilter = JobIdFilter;