"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatIndexPatternRequested = exports.ModalInspectQuery = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _reactRouterDom = require("react-router-dom");
var _use_selected_patterns = require("../../../data_view_manager/hooks/use_selected_patterns");
var _constants = require("../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _sourcerer_paths = require("../../../sourcerer/containers/sourcerer_paths");
var _containers = require("../../../sourcerer/containers");
var _model = require("../../../sourcerer/store/model");
var _use_experimental_features = require("../../hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiModal = (0, _styled.default)(_eui.EuiModal)`
  width: min(768px, calc(100vw - 16px));
  height: 41vh;

  .euiModal__flex {
    width: 60vw;
  }

  [role='tabpanel'] {
    /*
    * Current tabpanel height is based on the content inside it and since we are using virtualized codeblock,
    * which needs to have a fixed height of parent to render the codeblock properly, we will set tabpanel height
    * to take up any remaining space after header, footer and tabs in the Modal.
    *
    * height of the tabPanel is calculated according to the Modal height of 41vh
    * and then subtracting the height of the header, footer and the space between the tabs and the codeblock
    *
    * headerHeight + footerHeight + tabsHeight + paddingAroundCodeBlock = 208px
    *
    */
    height: calc(41vh - 208px) !important;
  }
`;
MyEuiModal.displayName = 'MyEuiModal';
const parseInspectStrings = function (stringsArray) {
  try {
    return stringsArray.map(objectStringify => JSON.parse(objectStringify));
  } catch {
    return [];
  }
};
const manageStringify = object => {
  try {
    return JSON.stringify(object, null, 2);
  } catch {
    return i18n.SOMETHING_WENT_WRONG;
  }
};
const formatIndexPatternRequested = (indices = []) => {
  if (indices.length === 1 && indices[0] === _constants.NO_ALERT_INDEX) {
    return /*#__PURE__*/_react.default.createElement("i", null, i18n.NO_ALERT_INDEX_FOUND);
  }
  return indices.length > 0 ? indices.filter(i => i !== _constants.NO_ALERT_INDEX).join(', ') : i18n.SOMETHING_WENT_WRONG;
};
exports.formatIndexPatternRequested = formatIndexPatternRequested;
const ModalInspectQuery = ({
  adHocDataViews,
  additionalRequests,
  additionalResponses,
  closeModal,
  inputId,
  request,
  response,
  title
}) => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const sourcererScope = inputId === 'timeline' ? _model.SourcererScopeName.timeline : (0, _sourcerer_paths.getScopeFromPath)(pathname);
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(sourcererScope);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(sourcererScope);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const requests = (0, _react.useMemo)(() => [request, ...(additionalRequests != null ? additionalRequests : [])], [request, additionalRequests]);
  const responses = (0, _react.useMemo)(() => [response, ...(additionalResponses != null ? additionalResponses : [])], [response, additionalResponses]);
  const inspectRequests = (0, _react.useMemo)(() => parseInspectStrings(requests), [requests]);
  const inspectResponses = (0, _react.useMemo)(() => parseInspectStrings(responses), [responses]);
  const isSourcererPattern = (0, _react.useMemo)(() => {
    var _inspectRequests$0$in, _inspectRequests$;
    return ((_inspectRequests$0$in = (_inspectRequests$ = inspectRequests[0]) === null || _inspectRequests$ === void 0 ? void 0 : _inspectRequests$.index) !== null && _inspectRequests$0$in !== void 0 ? _inspectRequests$0$in : []).every(pattern => selectedPatterns.includes(pattern.trim()));
  }, [inspectRequests, selectedPatterns]);
  const statistics = (0, _react.useMemo)(() => {
    var _inspectRequests$0$in2, _inspectRequests$2, _inspectResponses$, _inspectResponses$2;
    return [{
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "index-pattern-title"
      }, i18n.INDEX_PATTERN, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: i18n.INDEX_PATTERN_DESC,
        type: "info"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "index-pattern-description"
      }, /*#__PURE__*/_react.default.createElement("p", null, formatIndexPatternRequested(adHocDataViews != null && adHocDataViews.length > 0 ? adHocDataViews : (_inspectRequests$0$in2 = (_inspectRequests$2 = inspectRequests[0]) === null || _inspectRequests$2 === void 0 ? void 0 : _inspectRequests$2.index) !== null && _inspectRequests$0$in2 !== void 0 ? _inspectRequests$0$in2 : [])), !isSourcererPattern && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("i", {
        "data-test-subj": "not-sourcerer-msg"
      }, i18n.INSPECT_PATTERN_DIFFERENT))))
    }, {
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "query-time-title"
      }, i18n.QUERY_TIME, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: i18n.QUERY_TIME_DESC,
        type: "info"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "query-time-description"
      }, ((_inspectResponses$ = inspectResponses[0]) === null || _inspectResponses$ === void 0 ? void 0 : _inspectResponses$.took) === 0 ? '0ms' : (_inspectResponses$2 = inspectResponses[0]) !== null && _inspectResponses$2 !== void 0 && _inspectResponses$2.took ? `${(0, _numeral.default)(inspectResponses[0].took).format('0,0')}ms` : i18n.SOMETHING_WENT_WRONG)
    }, {
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "request-timestamp-title"
      }, i18n.REQUEST_TIMESTAMP, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: i18n.REQUEST_TIMESTAMP_DESC,
        type: "info"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "request-timestamp-description"
      }, new Date().toISOString())
    }];
  }, [adHocDataViews, inspectRequests, inspectResponses, isSourcererPattern]);
  const tabs = (0, _react.useMemo)(() => [{
    id: 'statistics',
    name: 'Statistics',
    'data-test-subj': 'modal-inspect-statistics-tab',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: statistics,
      type: "responsiveColumn",
      columnWidths: [3, 7]
    }))
  }, {
    id: 'request',
    name: 'Request',
    'data-test-subj': 'modal-inspect-request-tab',
    content: inspectRequests.length > 0 ? inspectRequests.map((inspectRequest, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      "data-test-subj": "modal-inspect-request-preview",
      language: "json",
      fontSize: "m",
      paddingSize: "m",
      color: "dark",
      overflowHeight: "100%",
      isCopyable: true,
      isVirtualized: true,
      lineNumbers: true
    }, manageStringify(inspectRequest.body)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, i18n.SOMETHING_WENT_WRONG)
  }, {
    id: 'response',
    name: 'Response',
    'data-test-subj': 'modal-inspect-response-tab',
    content: inspectResponses.length > 0 ? responses.map((responseText, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      "data-test-subj": "modal-inspect-response-preview",
      language: "json",
      fontSize: "m",
      paddingSize: "m",
      color: "dark",
      overflowHeight: "100%",
      isCopyable: true,
      isVirtualized: true,
      lineNumbers: true
    }, responseText))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, i18n.SOMETHING_WENT_WRONG)
  }], [inspectRequests, inspectResponses, responses, statistics]);
  return /*#__PURE__*/_react.default.createElement(MyEuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: closeModal,
    "data-test-subj": "modal-inspect-euiModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, i18n.INSPECT, " ", title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeModal,
    fill: true,
    "data-test-subj": "modal-inspect-close"
  }, i18n.CLOSE)));
};
exports.ModalInspectQuery = ModalInspectQuery;