"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportDataModalComponent = exports.ImportDataModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_app_toasts = require("../../hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ImportDataModalComponent = ({
  isModalVisible,
  closeModal,
  title,
  filePickerPrompt,
  description,
  submitBtnText,
  errorMessage,
  importData,
  onImportComplete,
  children
}) => {
  const [selectedFiles, setSelectedFiles] = (0, _react.useState)(null);
  const [isImporting, setIsImporting] = (0, _react.useState)(false);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const descriptionElementId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const cleanupAndCloseModal = (0, _react.useCallback)(() => {
    closeModal();
    setIsImporting(false);
    setSelectedFiles(null);
  }, [closeModal]);
  const importDataCallback = (0, _react.useCallback)(async () => {
    if (selectedFiles != null) {
      setIsImporting(true);
      const abortCtrl = new AbortController();
      try {
        const importResponse = await importData({
          fileToImport: selectedFiles[0],
          signal: abortCtrl.signal
        });
        setIsImporting(false);
        setSelectedFiles(null);
        onImportComplete(importResponse);
      } catch (error) {
        cleanupAndCloseModal();
        addError(error, {
          title: errorMessage(1)
        });
      }
    }
  }, [selectedFiles, importData, errorMessage, addError, onImportComplete, cleanupAndCloseModal]);
  const handleFilePickerChange = (0, _react.useCallback)(files => {
    setSelectedFiles(files && files.length > 0 ? files : null);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: cleanupAndCloseModal,
    maxWidth: '750px'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    id: descriptionElementId
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "data-test-subj": "rule-file-picker",
    accept: ".ndjson",
    id: "rule-file-picker",
    initialPromptText: filePickerPrompt,
    onChange: handleFilePickerChange,
    display: 'large',
    fullWidth: true,
    isLoading: isImporting,
    "aria-labelledby": descriptionElementId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), children), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: cleanupAndCloseModal
  }, i18n.CANCEL_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "import-data-modal-button",
    onClick: importDataCallback,
    disabled: selectedFiles == null || isImporting,
    fill: true
  }, submitBtnText))));
};
exports.ImportDataModalComponent = ImportDataModalComponent;
ImportDataModalComponent.displayName = 'ImportDataModalComponent';
const ImportDataModal = exports.ImportDataModal = /*#__PURE__*/_react.default.memo(ImportDataModalComponent);
ImportDataModal.displayName = 'ImportDataModal';