"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _title = require("./title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiButtonIcon = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-left: ${theme.eui.euiSize};
  `}
`;
const MySpinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-left: ${theme.eui.euiSize};
  `}
`;
const EditableTitleComponent = ({
  disabled = false,
  onSubmit,
  isLoading,
  title
}) => {
  const [editMode, setEditMode] = (0, _react.useState)(false);
  const [changedTitle, onTitleChange] = (0, _react.useState)(typeof title === 'string' ? title : '');
  const onCancel = (0, _react.useCallback)(() => setEditMode(false), []);
  const onClickEditIcon = (0, _react.useCallback)(() => setEditMode(true), []);
  const onClickSubmit = (0, _react.useCallback)(() => {
    if (changedTitle !== title) {
      onSubmit(changedTitle);
    }
    setEditMode(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [changedTitle, title]);
  const handleOnChange = (0, _react.useCallback)(e => onTitleChange(e.target.value), []);
  return editMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onChange: handleOnChange,
    value: `${changedTitle}`,
    "data-test-subj": "editable-title-input-field"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-test-subj": "editable-title-submit-btn",
    fill: true,
    iconType: "save",
    onClick: onClickSubmit,
    size: "s"
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "editable-title-cancel-btn",
    iconType: "cross",
    onClick: onCancel,
    size: "s"
  }, i18n.CANCEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isLoading && /*#__PURE__*/_react.default.createElement(MySpinner, {
    "data-test-subj": "editable-title-loading"
  }), !isLoading && /*#__PURE__*/_react.default.createElement(MyEuiButtonIcon, {
    isDisabled: disabled,
    "aria-label": i18n.EDIT_TITLE_ARIA(title),
    iconType: "pencil",
    onClick: onClickEditIcon,
    "data-test-subj": "editable-title-edit-icon"
  })));
};
const EditableTitle = exports.EditableTitle = /*#__PURE__*/_react.default.memo(EditableTitleComponent);