"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityTourStep = exports.GuidedOnboardingTourStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_selector = require("../../hooks/use_selector");
var _types = require("../../../../common/types");
var _defaults = require("../../../timelines/store/defaults");
var _store = require("../../../timelines/store");
var _tour = require("./tour");
var _tour_config = require("./tour_config");
var _use_hidden_by_flyout = require("./use_hidden_by_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isStepExternallyMounted = (tourId, step) => (step === _tour_config.AlertsCasesTourSteps.createCase || step === _tour_config.AlertsCasesTourSteps.submitCase) && tourId === _tour_config.SecurityStepId.alertsCases;
const StyledTourStep = (0, _styled.default)(_eui.EuiTourStep)`
  &.euiPopover__panel[data-popover-open] {
    z-index: ${({
  step,
  tourId
}) => isStepExternallyMounted(tourId, step) ? '9000 !important' : '1000 !important'};
  }
`;
const SecurityTourStep = exports.SecurityTourStep = /*#__PURE__*/_react.default.memo(({
  children,
  onClick,
  step,
  tourId
}) => {
  const {
    activeStep,
    incrementStep,
    isTourShown
  } = (0, _tour.useTourContext)();
  const tourStep = (0, _react.useMemo)(() => _tour_config.securityTourConfig[tourId].find(config => config.step === step), [step, tourId]);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const showTimeline = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, _types.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).show;
  });
  const onClickNext = (0, _react.useCallback)(
  // onClick should call incrementStep itself
  () => onClick ? onClick() : incrementStep(tourId), [incrementStep, onClick, tourId]);

  // EUI bug, will remove once bug resolve. will link issue here as soon as i have it
  const onKeyDown = (0, _react.useCallback)(e => {
    if (e.key === 'Enter') {
      e.stopPropagation();
    }
  }, []);

  // steps in Cases app are out of context.
  // If we mount this step, we know we need to render it
  // we are also managing the context on the siem end in the background
  const overrideContext = isStepExternallyMounted(tourId, step);
  if (tourStep == null || (step !== activeStep || !isTourShown(tourId)) && !overrideContext || showTimeline) {
    return children ? children : null;
  }
  const {
    anchor,
    content,
    imageConfig,
    dataTestSubj,
    hideNextButton = false,
    ...rest
  } = tourStep;
  const footerAction = !hideNextButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClickNext,
    onKeyDown: onKeyDown,
    size: "xs",
    color: "text",
    flush: "right",
    "data-test-subj": "onboarding--securityTourNextStepButton",
    "tour-step": "nextButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.guided_onboarding.nextStep.buttonLabel",
    defaultMessage: "Next"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const commonProps = {
    ...rest,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, content)), imageConfig && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      alt: imageConfig.altText,
      src: imageConfig.src,
      size: "fullWidth"
    }))),
    footerAction,
    // we would not have mounted this component if it was not open
    isStepOpen: true,
    // guided onboarding does not allow skipping tour through the steps
    onFinish: () => null,
    stepsTotal: _tour_config.securityTourConfig[tourId].length,
    panelProps: {
      'data-test-subj': dataTestSubj
    }
  };

  // tour step either needs children or an anchor element
  //  see type EuiTourStepAnchorProps
  return anchor != null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledTourStep, (0, _extends2.default)({
    tourId: tourId
  }, commonProps, {
    anchor: anchor
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)) : children != null ? /*#__PURE__*/_react.default.createElement(StyledTourStep, (0, _extends2.default)({
    tourId: tourId
  }, commonProps), children) : null;
});
SecurityTourStep.displayName = 'SecurityTourStep';
// wraps tour anchor component
// and gives the tour step itself a place to mount once it is active
// mounts the tour step with a delay to ensure the anchor will render first
const GuidedOnboardingTourStep = exports.GuidedOnboardingTourStep = /*#__PURE__*/_react.default.memo(({
  children,
  // can be false if the anchor is an iterative element
  // do not use this as an "is tour active" check, the SecurityTourStep checks that anyway
  isTourAnchor = true,
  ...props
}) => {
  return isTourAnchor ? /*#__PURE__*/_react.default.createElement(SecurityTourStepAnchor, props, children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
GuidedOnboardingTourStep.displayName = 'GuidedOnboardingTourStep';
const SecurityTourStepAnchor = /*#__PURE__*/_react.default.memo(({
  children,
  ...props
}) => {
  const {
    hidden: allStepsHidden
  } = (0, _tour.useTourContext)();
  const hiddenByFlyout = (0, _use_hidden_by_flyout.useHiddenByFlyout)({
    tourId: props.tourId,
    step: props.step
  });
  return !allStepsHidden && !hiddenByFlyout ? /*#__PURE__*/_react.default.createElement(SecurityTourStep, props, children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
SecurityTourStepAnchor.displayName = 'SecurityTourStepAnchor';