"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.EVENT_SUMMARY_CONVERSATION_ID = exports.EVENT_SUMMARY_CONTEXT_DESCRIPTION = exports.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.ALERT_SUMMARY_CONVERSATION_ID = exports.ALERT_SUMMARY_CONTEXT_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_SUMMARY_CONVERSATION_ID = exports.ALERT_SUMMARY_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewConversationId', {
  defaultMessage: 'Alert summary'
});
const ALERT_SUMMARY_CONTEXT_DESCRIPTION = view => _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewContextDescription', {
  defaultMessage: 'Alert (from {view})',
  values: {
    view
  }
});
exports.ALERT_SUMMARY_CONTEXT_DESCRIPTION = ALERT_SUMMARY_CONTEXT_DESCRIPTION;
const ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewContextTooltip', {
  defaultMessage: 'Add this alert as context'
});
const EVENT_SUMMARY_CONVERSATION_ID = exports.EVENT_SUMMARY_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewConversationId', {
  defaultMessage: 'Event summary'
});
const EVENT_SUMMARY_CONTEXT_DESCRIPTION = view => _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewContextDescription', {
  defaultMessage: 'Event (from {view})',
  values: {
    view
  }
});
exports.EVENT_SUMMARY_CONTEXT_DESCRIPTION = EVENT_SUMMARY_CONTEXT_DESCRIPTION;
const EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewContextTooltip', {
  defaultMessage: 'Add this event as context'
});