"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiSelectPopover = exports.MultiSelectPopover = /*#__PURE__*/_react.default.memo(({
  allItems,
  selectedItems,
  title,
  onSelectedItemsChange
}) => {
  const [isItemPopoverOpen, setIsItemPopoverOpen] = (0, _react.useState)(false);
  const onChange = (0, _react.useCallback)(item => onSelectedItemsChange(getUpdatedSelectedItems(item, selectedItems)), [selectedItems, onSelectedItemsChange]);
  const itemList = (0, _react.useMemo)(() => {
    return allItems.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: selectedItems.includes(item) ? 'on' : undefined,
      key: `${index}-${item}`,
      onClick: () => onChange(item),
      title: item
    }, item));
  }, [allItems, selectedItems, onChange]);
  const togglePopover = (0, _react.useCallback)(toState => {
    setIsItemPopoverOpen(s => toState ? toState : !s);
  }, [setIsItemPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      grow: false,
      "data-test-subj": 'multiselect-popover-button',
      iconType: "arrowDown",
      onClick: () => togglePopover(),
      numFilters: allItems.length,
      isSelected: isItemPopoverOpen,
      hasActiveFilters: selectedItems.length > 0,
      numActiveFilters: selectedItems.length
    }, title)),
    isOpen: isItemPopoverOpen,
    closePopover: () => togglePopover(false),
    panelPaddingSize: "none"
  }, itemList);
});
MultiSelectPopover.displayName = 'MultiSelectPopover';
const getUpdatedSelectedItems = (item, selectedItems) => {
  const selectedGroupIndex = selectedItems.indexOf(item);
  const updatedSelectedItems = [...selectedItems];
  if (selectedGroupIndex >= 0) {
    updatedSelectedItems.splice(selectedGroupIndex, 1);
  } else {
    updatedSelectedItems.push(item);
  }
  return updatedSelectedItems;
};