"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilitiesPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _use_vulnerabilities_preview = require("@kbn/cloud-security-posture/src/hooks/use_vulnerabilities_preview");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _expandable_panel = require("../../../flyout/shared/components/expandable_panel");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilitiesCount = ({
  vulnerabilitiesTotal,
  euiTheme
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, vulnerabilitiesTotal))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.vulnerabilities.vulnerabilitiesCountDescription",
    defaultMessage: "Vulnerabilities"
  })))));
};
const VulnerabilitiesPreview = ({
  value,
  field,
  isPreviewMode,
  isLinkEnabled,
  openDetailsPanel
}) => {
  (0, _react.useEffect)(() => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ENTITY_FLYOUT_WITH_VULNERABILITY_PREVIEW);
  }, []);
  const {
    data
  } = (0, _use_vulnerabilities_preview.useVulnerabilitiesPreview)({
    query: (0, _cloudSecurityPostureCommon.buildGenericEntityFlyoutPreviewQuery)(field, value),
    sort: [],
    enabled: true,
    pageSize: 1
  });
  const {
    CRITICAL = 0,
    HIGH = 0,
    MEDIUM = 0,
    LOW = 0,
    NONE = 0
  } = (data === null || data === void 0 ? void 0 : data.count) || {};
  const totalVulnerabilities = CRITICAL + HIGH + MEDIUM + LOW + NONE;
  const hasVulnerabilitiesFindings = (0, _cloudSecurityPosture.hasVulnerabilitiesData)({
    critical: CRITICAL,
    high: HIGH,
    medium: MEDIUM,
    low: LOW,
    none: NONE
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const goToEntityInsightTab = (0, _react.useCallback)(() => {
    openDetailsPanel({
      tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
      subTab: _left_panel_header.CspInsightLeftPanelSubTab.VULNERABILITIES
    });
  }, [openDetailsPanel]);
  const link = (0, _react.useMemo)(() => isLinkEnabled ? {
    callback: goToEntityInsightTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.vulnerabilities.vulnerabilitiesTooltip",
      defaultMessage: "Show all vulnerabilities findings"
    })
  } : undefined, [isLinkEnabled, goToEntityInsightTab]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      iconType: !isPreviewMode && hasVulnerabilitiesFindings ? 'arrowStart' : '',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.vulnerabilities.vulnerabilitiesTitle",
        defaultMessage: "Vulnerabilities"
      })),
      link
    },
    "data-test-subj": 'securitySolutionFlyoutInsightsVulnerabilities'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(VulnerabilitiesCount, {
    vulnerabilitiesTotal: (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(totalVulnerabilities),
    euiTheme: euiTheme
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: (0, _cloudSecurityPosture.getVulnerabilityStats)({
      critical: CRITICAL,
      high: HIGH,
      medium: MEDIUM,
      low: LOW,
      none: NONE
    })
  }))))));
};
exports.VulnerabilitiesPreview = VulnerabilitiesPreview;