"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SKELETON_TEST_ID = exports.ERROR_TEST_ID = exports.CONTENT_TEST_ID = exports.AiForSOCAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _table = require("./table");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _use_fetch_integrations = require("../../../detections/hooks/alert_summary/use_fetch_integrations");
var _use_find_rules_query = require("../../../detection_engine/rule_management/api/hooks/use_find_rules_query");
var _use_create_data_view = require("../../../common/hooks/use_create_data_view");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _model = require("../../../sourcerer/store/model");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATAVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.aiForSocTableTab.dataViewError', {
  defaultMessage: 'Unable to create data view'
});
const ERROR_TEST_ID = exports.ERROR_TEST_ID = 'cases-alert-error';
const SKELETON_TEST_ID = exports.SKELETON_TEST_ID = 'cases-alert-skeleton';
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'cases-alert-content';
/**
 * Component used in the Cases page under the Alerts tab, only in the AI4DSOC tier.
 * It fetches rules, packages (integrations) and creates a local dataView.
 * It renders a loading skeleton while packages are being fetched and while the dataView is being created.
 */
const AiForSOCAlertsTable = exports.AiForSOCAlertsTable = /*#__PURE__*/(0, _react.memo)(({
  id,
  onLoaded,
  query
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const spaceId = (0, _use_space_id.useSpaceId)();
  const dataViewSpec = (0, _react.useMemo)(() => ({
    title: `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`
  }), [spaceId]);
  const {
    dataView: oldDataView,
    loading: oldDataViewLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    dataViewSpec,
    skip: newDataViewPickerEnabled // skip data view creation if the new data view picker is enabled
  });
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const dataViewLoading = newDataViewPickerEnabled ? status !== 'ready' : oldDataViewLoading;
  const dataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;

  // Fetch all integrations
  const {
    installedPackages,
    isLoading: integrationIsLoading
  } = (0, _use_fetch_integrations.useFetchIntegrations)();

  // Fetch all rules. For the AI for SOC effort, there should only be one rule per integration (which means for now 5-6 rules total)
  const {
    data: ruleData,
    isLoading: ruleIsLoading
  } = (0, _use_find_rules_query.useFindRulesQuery)({});
  const ruleResponse = (0, _react.useMemo)(() => ({
    rules: (ruleData === null || ruleData === void 0 ? void 0 : ruleData.rules) || [],
    isLoading: ruleIsLoading
  }), [ruleData, ruleIsLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    "data-test-subj": SKELETON_TEST_ID,
    height: 400,
    isLoading: integrationIsLoading || dataViewLoading,
    width: "100%"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !dataView || !dataView.id ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "danger",
    "data-test-subj": ERROR_TEST_ID,
    iconType: "error",
    title: /*#__PURE__*/_react.default.createElement("h2", null, DATAVIEW_ERROR)
  }) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": CONTENT_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_table.Table, {
    dataView: dataView,
    id: id,
    onLoaded: onLoaded,
    packages: installedPackages,
    query: query,
    ruleResponse: ruleResponse
  }))));
});
AiForSOCAlertsTable.displayName = 'AiForSOCAlertsTable';