"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFindAttackDiscoverySchedule = exports.useFindAttackDiscoverySchedules = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../api");
var _constants = require("./constants");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindAttackDiscoverySchedules = params => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    disableToast,
    ...restParams
  } = params !== null && params !== void 0 ? params : {};
  return (0, _reactQuery.useQuery)(['GET', _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_FIND, params], async ({
    signal
  }) => {
    const response = await (0, _api.findAttackDiscoverySchedule)({
      signal,
      ...restParams
    });
    return {
      schedules: response.data,
      total: response.total
    };
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    onError: error => {
      if (!disableToast) {
        addError(error, {
          title: i18n.FETCH_ATTACK_DISCOVERY_SCHEDULES_FAILURE(false)
        });
      }
    }
  });
};

/**
 * We should use this hook to invalidate the attack discovery schedule cache. For
 * example, attack discovery schedule mutations, like create a schedule, should lead to cache invalidation.
 *
 * @returns A attack discovery schedule cache invalidation callback
 */
exports.useFindAttackDiscoverySchedules = useFindAttackDiscoverySchedules;
const useInvalidateFindAttackDiscoverySchedule = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    /**
     * Invalidate all queries that start with ATTACK_DISCOVERY_SCHEDULES_FIND. This
     * includes the in-memory query cache and paged query cache.
     */
    queryClient.invalidateQueries(['GET', _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_FIND], {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFindAttackDiscoverySchedule = useInvalidateFindAttackDiscoverySchedule;