"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelectorField = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSelectorField = exports.ConnectorSelectorField = /*#__PURE__*/_react.default.memo(({
  connectorId,
  field,
  onConnectorIdSelected
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true,
    "data-test-subj": "attackDiscoveryConnectorSelectorField"
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    fullWidth: true,
    onConnectorSelected: _fp.noop,
    onConnectorIdSelected: onConnectorIdSelected,
    selectedConnectorId: connectorId
  }));
});
ConnectorSelectorField.displayName = 'ConnectorSelectorField';