"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../../common/lib/kibana");
var _confirmation_modal = require("../confirmation_modal");
var _containers = require("../../../../../sourcerer/containers");
var _footer = require("../../footer");
var _constants = require("../../constants");
var _use_update_schedule = require("../logic/use_update_schedule");
var _use_get_schedule = require("../logic/use_get_schedule");
var _helpers = require("../../../helpers");
var _use_edit_form = require("../edit_form/use_edit_form");
var _definition = require("./definition");
var _header = require("./header");
var _execution_logs = require("./execution_logs");
var _convert_form_data = require("../utils/convert_form_data");
var _constants2 = require("../../../../../data_view_manager/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsFlyout = exports.DetailsFlyout = /*#__PURE__*/_react.default.memo(({
  scheduleId,
  onClose
}) => {
  const [hasUnsavedChanges, setHasUnsavedChanges] = (0, _react.useState)(false);
  const onFormMutated = (0, _react.useCallback)(() => setHasUnsavedChanges(true), []);
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const onCancel = (0, _react.useCallback)(() => {
    setShowConfirmModal(false); // just close the modal
  }, []);
  const onDiscard = (0, _react.useCallback)(() => {
    setShowConfirmModal(false);
    onClose();
  }, [onClose]);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'attackDiscoveryScheduleDetailsFlyoutTitle'
  });
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    alertsIndexPattern,
    http
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: aiConnectors,
    isLoading: isLoadingConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http
  });
  const {
    data: {
      schedule
    } = {
      schedule: undefined
    },
    isLoading: isLoadingSchedule
  } = (0, _use_get_schedule.useGetAttackDiscoverySchedule)({
    id: scheduleId
  });
  const {
    sourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants2.DataViewManagerScopeName.detections);
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const {
    mutateAsync: updateAttackDiscoverySchedule,
    isLoading: isLoadingQuery
  } = (0, _use_update_schedule.useUpdateAttackDiscoverySchedule)();
  const onUpdateSchedule = (0, _react.useCallback)(async scheduleData => {
    const connector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.find(item => item.id === scheduleData.connectorId);
    if (!connector) {
      return;
    }
    try {
      const scheduleToUpdate = (0, _convert_form_data.convertFormDataInBaseSchedule)(scheduleData, alertsIndexPattern !== null && alertsIndexPattern !== void 0 ? alertsIndexPattern : '', connector, sourcererDataView, uiSettings, experimentalDataView);
      await updateAttackDiscoverySchedule({
        id: scheduleId,
        scheduleToUpdate
      });
      setIsEditing(false);
    } catch (err) {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    }
  }, [aiConnectors, alertsIndexPattern, sourcererDataView, uiSettings, experimentalDataView, updateAttackDiscoverySchedule, scheduleId]);
  const isLoading = isLoadingSchedule || isLoadingConnectors || isLoadingQuery;
  const formInitialValue = (0, _react.useMemo)(() => {
    if (schedule) {
      var _params$query, _ref, _params$start, _params$end;
      const params = schedule.params;
      return {
        name: schedule.name,
        connectorId: params.apiConfig.connectorId,
        alertsSelectionSettings: {
          query: (_params$query = params.query) !== null && _params$query !== void 0 ? _params$query : (0, _helpers.getDefaultQuery)(),
          filters: (_ref = params.filters) !== null && _ref !== void 0 ? _ref : [],
          size: params.size,
          start: (_params$start = params.start) !== null && _params$start !== void 0 ? _params$start : _elasticAssistantCommon.DEFAULT_START,
          end: (_params$end = params.end) !== null && _params$end !== void 0 ? _params$end : _elasticAssistantCommon.DEFAULT_END
        },
        interval: schedule.schedule.interval,
        actions: schedule.actions
      };
    }
  }, [schedule]);
  const {
    editForm,
    actionButtons: editingActionButtons
  } = (0, _use_edit_form.useEditForm)({
    initialValue: formInitialValue,
    isLoading,
    onFormMutated,
    onSave: onUpdateSchedule,
    saveButtonTitle: i18n.SCHEDULE_SAVE_BUTTON_TITLE
  });
  const scheduleDetails = (0, _react.useMemo)(() => {
    if (schedule) {
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "scheduleDetails"
      }, /*#__PURE__*/_react.default.createElement(_definition.ScheduleDefinition, {
        schedule: schedule
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl"
      }), /*#__PURE__*/_react.default.createElement(_execution_logs.ScheduleExecutionLogs, {
        schedule: schedule
      }));
    }
  }, [schedule]);
  const content = (0, _react.useMemo)(() => {
    if (isEditing) {
      return editForm;
    }
    return scheduleDetails;
  }, [editForm, isEditing, scheduleDetails]);
  const editButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: (0, _react2.css)`
            margin-right: ${euiTheme.size.s};
          `,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "edit",
      size: "m",
      onClick: () => setIsEditing(true),
      disabled: isLoading
    }, i18n.SCHEDULE_EDIT_BUTTON_TITLE))));
  }, [euiTheme.size.s, isLoading]);
  const actionButtons = (0, _react.useMemo)(() => {
    return isEditing ? editingActionButtons : [editButton];
  }, [editButton, editingActionButtons, isEditing]);
  const handleCloseButtonClick = (0, _react.useCallback)(() => {
    if (hasUnsavedChanges) {
      setShowConfirmModal(true);
    } else {
      onClose();
      setIsEditing(false);
    }
  }, [hasUnsavedChanges, onClose]);
  const onKeyDown = (0, _react.useCallback)(ev => {
    if ((0, _eui.isDOMNode)(ev.target) && ev.currentTarget.contains(ev.target) && ev.key === _eui.keys.ESCAPE) {
      ev.preventDefault();
      ev.stopPropagation();
      handleCloseButtonClick();
    }
  }, [handleCloseButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    "aria-labelledby": flyoutTitleId,
    "data-test-subj": "scheduleDetailsFlyout",
    minWidth: _constants.MIN_FLYOUT_WIDTH,
    onClose: handleCloseButtonClick,
    onKeyDown: onKeyDown,
    outsideClickCloses: !isEditing,
    paddingSize: "m",
    side: "right",
    size: "m",
    type: "overlay"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header.Header, {
    isEditing: isEditing,
    isLoading: isLoading,
    schedule: schedule,
    titleId: flyoutTitleId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    closeModal: handleCloseButtonClick,
    actionButtons: actionButtons
  }))), showConfirmModal && /*#__PURE__*/_react.default.createElement(_confirmation_modal.ConfirmationModal, {
    onCancel: onCancel,
    onDiscard: onDiscard
  }));
});
DetailsFlyout.displayName = 'DetailsFlyout';