"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleDefinition = void 0;
exports.getQueryLanguageLabel = getQueryLanguageLabel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _filters = require("./filters");
var _common_field = require("./common_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS = ['30%', '70%'];
function getQueryLanguageLabel(language) {
  switch (language) {
    case 'kuery':
      return i18n.KUERY_LANGUAGE_LABEL;
    case 'lucene':
      return i18n.LUCENE_LANGUAGE_LABEL;
    default:
      return language;
  }
}
const ScheduleDefinition = exports.ScheduleDefinition = /*#__PURE__*/_react.default.memo(({
  schedule
}) => {
  const definitionSectionListItems = (0, _react.useMemo)(() => {
    var _schedule$params$filt, _schedule$params$quer;
    const items = [];
    if ((_schedule$params$filt = schedule.params.filters) !== null && _schedule$params$filt !== void 0 && _schedule$params$filt.length) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "filtersTitle"
        }, i18n.FILTERS_LABEL),
        description: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "filtersValue"
        }, /*#__PURE__*/_react.default.createElement(_filters.Filters, {
          filters: schedule.params.filters
        }))
      });
    }
    if ((_schedule$params$quer = schedule.params.query) !== null && _schedule$params$quer !== void 0 && _schedule$params$quer.query.length) {
      const query = schedule.params.query;
      items.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "queryTitle"
        }, i18n.QUERY_LABEL),
        description: /*#__PURE__*/_react.default.createElement(_common_field.CommonField, {
          value: typeof query.query === 'string' ? query.query : JSON.stringify(query.query),
          "data-test-subj": "queryValue"
        })
      }, {
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "queryLanguageTitle"
        }, i18n.QUERY_LANGUAGE_LABEL),
        description: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "queryLanguageValue"
        }, getQueryLanguageLabel(query.language))
      });
    }
    items.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "scheduleIntervalTitle"
      }, i18n.SCHEDULE_INTERVAL_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_common_field.CommonField, {
        value: (0, _common.formatDuration)(schedule.schedule.interval, true),
        "data-test-subj": "scheduleIntervalValue"
      })
    });
    items.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "connectorTitle"
      }, i18n.CONNECTOR_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_common_field.CommonField, {
        value: schedule.params.apiConfig.name,
        "data-test-subj": "connectorValue"
      })
    });
    return items;
  }, [schedule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "definitionTitle",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.DEFINITION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "scheduleDetailsDefinition"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: 'column',
    rowGutterSize: 'm',
    listItems: definitionSectionListItems,
    columnWidths: DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
    "data-test-subj": "listItemColumnScheduleDescription"
  })));
});
ScheduleDefinition.displayName = 'ScheduleDefinition';