"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateFlyout = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../data_view_manager/constants");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _kibana = require("../../../../../common/lib/kibana");
var _confirmation_modal = require("../confirmation_modal");
var _containers = require("../../../../../sourcerer/containers");
var _footer = require("../../footer");
var _constants2 = require("../../constants");
var _edit_form = require("../edit_form");
var _use_create_schedule = require("../logic/use_create_schedule");
var i18n = _interopRequireWildcard(require("./translations"));
var _convert_form_data = require("../utils/convert_form_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateFlyout = exports.CreateFlyout = /*#__PURE__*/_react.default.memo(({
  onClose
}) => {
  const [hasUnsavedChanges, setHasUnsavedChanges] = (0, _react.useState)(false);
  const onFormMutated = (0, _react.useCallback)(() => setHasUnsavedChanges(true), []);
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const onCancel = (0, _react.useCallback)(() => {
    setShowConfirmModal(false); // just close the modal
  }, []);
  const onDiscard = (0, _react.useCallback)(() => {
    setShowConfirmModal(false);
    onClose();
  }, [onClose]);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'attackDiscoveryScheduleCreateFlyoutTitle'
  });
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const {
    alertsIndexPattern,
    http
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: aiConnectors,
    isLoading: isLoadingConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http
  });
  const {
    sourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants.DataViewManagerScopeName.detections);
  const {
    mutateAsync: createAttackDiscoverySchedule,
    isLoading: isLoadingQuery
  } = (0, _use_create_schedule.useCreateAttackDiscoverySchedule)();
  const onCreateSchedule = (0, _react.useCallback)(async scheduleData => {
    const connector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.find(item => item.id === scheduleData.connectorId);
    if (!connector) {
      return;
    }
    try {
      const scheduleToCreate = (0, _convert_form_data.convertFormDataInBaseSchedule)(scheduleData, alertsIndexPattern !== null && alertsIndexPattern !== void 0 ? alertsIndexPattern : '', connector, sourcererDataView, uiSettings, experimentalDataView);
      await createAttackDiscoverySchedule({
        scheduleToCreate
      });
      onClose();
    } catch (err) {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    }
  }, [aiConnectors, alertsIndexPattern, createAttackDiscoverySchedule, experimentalDataView, onClose, sourcererDataView, uiSettings]);
  const {
    editForm,
    actionButtons
  } = (0, _edit_form.useEditForm)({
    isLoading: isLoadingConnectors || isLoadingQuery,
    onFormMutated,
    onSave: onCreateSchedule,
    saveButtonTitle: i18n.SCHEDULE_CREATE_BUTTON_TITLE
  });
  const handleCloseButtonClick = (0, _react.useCallback)(() => {
    if (hasUnsavedChanges) {
      setShowConfirmModal(true);
    } else {
      onClose();
    }
  }, [hasUnsavedChanges, onClose]);
  const onKeyDown = (0, _react.useCallback)(ev => {
    if ((0, _eui.isDOMNode)(ev.target) && ev.currentTarget.contains(ev.target) && ev.key === _eui.keys.ESCAPE) {
      ev.preventDefault();
      ev.stopPropagation();
      handleCloseButtonClick();
    }
  }, [handleCloseButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    "aria-labelledby": flyoutTitleId,
    "data-test-subj": "scheduleCreateFlyout",
    minWidth: _constants2.MIN_FLYOUT_WIDTH,
    onClose: handleCloseButtonClick,
    onKeyDown: onKeyDown,
    paddingSize: "m",
    side: "right",
    size: "m",
    type: "overlay"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "title",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, i18n.SCHEDULE_CREATE_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), editForm), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    closeModal: handleCloseButtonClick,
    actionButtons: actionButtons
  }))), showConfirmModal && /*#__PURE__*/_react.default.createElement(_confirmation_modal.ConfirmationModal, {
    onCancel: onCancel,
    onDiscard: onDiscard
  }));
});
CreateFlyout.displayName = 'CreateFlyout';