"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Results = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireDefault(require("react"));
var _current = require("./current");
var _empty_states = require("./empty_states");
var _show_empty_states = require("./empty_states/helpers/show_empty_states");
var _history = require("./history");
var _use_kibana_feature_flags = require("../use_kibana_feature_flags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultsComponent = ({
  aiConnectors,
  alertsContextCount,
  alertsCount,
  approximateFutureTime,
  attackDiscoveriesCount,
  connectorId,
  connectorIntervals,
  end,
  failureReason,
  isLoading,
  isLoadingPost,
  localStorageAttackDiscoveryMaxAlerts,
  loadingConnectorId,
  onGenerate,
  onToggleShowAnonymized,
  selectedConnectorAttackDiscoveries,
  selectedConnectorLastUpdated,
  selectedConnectorReplacements,
  showAnonymized,
  start,
  stats
}) => {
  var _aiConnectors$length;
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const aiConnectorsCount = (_aiConnectors$length = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.length) !== null && _aiConnectors$length !== void 0 ? _aiConnectors$length : null; // null when connectors are not configured

  if (!attackDiscoveryAlertsEnabled && (0, _show_empty_states.showEmptyStates)({
    aiConnectorsCount,
    alertsContextCount,
    attackDiscoveriesCount,
    connectorId,
    failureReason,
    isLoading
  })) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react.default.createElement(_empty_states.EmptyStates, {
      aiConnectorsCount: aiConnectorsCount,
      alertsContextCount: alertsContextCount,
      attackDiscoveriesCount: attackDiscoveriesCount,
      failureReason: failureReason,
      connectorId: connectorId,
      isLoading: isLoading || isLoadingPost,
      onGenerate: onGenerate,
      upToAlertsCount: Number(localStorageAttackDiscoveryMaxAlerts !== null && localStorageAttackDiscoveryMaxAlerts !== void 0 ? localStorageAttackDiscoveryMaxAlerts : _elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS)
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, attackDiscoveryAlertsEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_history.History, {
    aiConnectors: aiConnectors,
    localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
    onGenerate: onGenerate,
    onToggleShowAnonymized: onToggleShowAnonymized,
    showAnonymized: showAnonymized
  })) : /*#__PURE__*/_react.default.createElement(_current.Current, {
    aiConnectorsCount: aiConnectorsCount,
    alertsContextCount: alertsContextCount,
    alertsCount: alertsCount,
    approximateFutureTime: approximateFutureTime,
    attackDiscoveriesCount: attackDiscoveriesCount,
    connectorId: connectorId,
    connectorIntervals: connectorIntervals,
    end: end,
    failureReason: failureReason,
    isLoading: isLoading,
    isLoadingPost: isLoadingPost,
    loadingConnectorId: loadingConnectorId,
    localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
    onGenerate: onGenerate,
    onToggleShowAnonymized: onToggleShowAnonymized,
    selectedConnectorAttackDiscoveries: selectedConnectorAttackDiscoveries,
    selectedConnectorLastUpdated: selectedConnectorLastUpdated,
    selectedConnectorReplacements: selectedConnectorReplacements,
    showAnonymized: showAnonymized,
    start: start,
    stats: stats
  }));
};
ResultsComponent.displayName = 'Results';
const Results = exports.Results = /*#__PURE__*/_react.default.memo(ResultsComponent);