"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VISIBLE_TO_YOUR_TEAM = exports.VISIBILITY = exports.STATUS = exports.SHARED = exports.SEARCH = exports.OPEN = exports.ONLY_VISIBLE_TO_YOU = exports.NOT_SHARED = exports.HIDDEN = exports.DELETED = exports.CONNECTOR = exports.CLOSED = exports.CLEAR_FILTER_ID = exports.ACKNOWLEDGED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACKNOWLEDGED = exports.ACKNOWLEDGED = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.acknowledgedFilterLabel', {
  defaultMessage: 'Acknowledged'
});
const CLEAR_FILTER_ID = id => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.clearFilterIdLabel', {
  values: {
    id
  },
  defaultMessage: `Clear filter _id:{id}`
});
exports.CLEAR_FILTER_ID = CLEAR_FILTER_ID;
const CLOSED = exports.CLOSED = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.closedFilterLabel', {
  defaultMessage: 'Closed'
});
const CONNECTOR = exports.CONNECTOR = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.connectorDropdownLabel', {
  defaultMessage: 'Connector'
});
const DELETED = exports.DELETED = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.deletedFilterLabel', {
  defaultMessage: 'Deleted'
});
const HIDDEN = exports.HIDDEN = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.hiddenFilterLabel', {
  defaultMessage: 'Hidden'
});
const ONLY_VISIBLE_TO_YOU = exports.ONLY_VISIBLE_TO_YOU = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.onlyVisibleToYouFilterLabel', {
  defaultMessage: 'Only visible to you'
});
const OPEN = exports.OPEN = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.openFilterLabel', {
  defaultMessage: 'Open'
});
const NOT_SHARED = exports.NOT_SHARED = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.notSharedFilterLabel', {
  defaultMessage: 'Not shared'
});
const SEARCH = exports.SEARCH = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.searchPlaceholder', {
  defaultMessage: 'Search'
});
const SHARED = exports.SHARED = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.sharedFilterLabel', {
  defaultMessage: 'Shared'
});
const STATUS = exports.STATUS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.statusDropdownLabel', {
  defaultMessage: 'Status'
});
const VISIBILITY = exports.VISIBILITY = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.visibilityDropdownLabel', {
  defaultMessage: 'Visibility'
});
const VISIBLE_TO_YOUR_TEAM = exports.VISIBLE_TO_YOUR_TEAM = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.tabs.previousTab.searchAndFilter.visibleToYourTeamFilterLabel', {
  defaultMessage: 'Visible to your team'
});