"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Subtitle = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../../../common/lib/kibana");
var _is_attack_discovery_alert = require("../../../../../utils/is_attack_discovery_alert");
var _get_formatted_time = require("../../../../../loading_callout/loading_messages/get_formatted_time");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubtitleComponent = ({
  attackDiscovery
}) => {
  const {
    euiTheme: {
      font
    }
  } = (0, _eui.useEuiTheme)();
  const userName = (0, _react2.useMemo)(() => (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery) ? attackDiscovery.userName : null, [attackDiscovery]);
  const userId = (0, _react2.useMemo)(() => (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery) ? attackDiscovery.userId : null, [attackDiscovery]);
  const createdBy = (0, _react2.useMemo)(() => {
    const user = userName !== null && userName !== void 0 ? userName : userId;
    return user != null ? i18n.CREATED_BY_USER(user) : null;
  }, [userId, userName]);
  const dateFormat = (0, _kibana.useDateFormat)();
  const formattedTimestamp = (0, _react2.useMemo)(() => (0, _get_formatted_time.getFormattedDate)({
    date: attackDiscovery.timestamp,
    dateFormat
  }), [attackDiscovery.timestamp, dateFormat]);
  return (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery) ? /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
        font-size: ${font.scale.xxs}${font.defaultUnits};
      `,
    color: "subdued",
    "data-test-subj": "subtitle"
  }, /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "timestamp"
  }, formattedTimestamp), "\xA0\xA0", /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "createdBy"
  }, createdBy)) : null;
};
SubtitleComponent.displayName = 'Subtitle';
const Subtitle = exports.Subtitle = /*#__PURE__*/_react2.default.memo(SubtitleComponent);