"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharedBadge = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _use_attack_discovery_bulk = require("../../../../../../use_attack_discovery_bulk");
var _use_find_attack_discoveries = require("../../../../../../use_find_attack_discoveries");
var _is_attack_discovery_alert = require("../../../../../../utils/is_attack_discovery_alert");
var _use_kibana_feature_flags = require("../../../../../../use_kibana_feature_flags");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LIST_PROPS = {
  isVirtualized: false,
  rowHeight: 60
};
const SharedBadgeComponent = ({
  attackDiscovery
}) => {
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();
  const onBadgeButtonClick = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(isOpen => !isOpen);
  }, []);
  const closePopover = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'visibilityFilterGroupPopover'
  });
  const isShared = (0, _react2.useMemo)(() => {
    if (!(0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery)) {
      return false;
    }
    if ((0, _fp.isEmpty)(attackDiscovery.users)) {
      return true;
    }
    return attackDiscovery.users != null && attackDiscovery.users.length > 1;
  }, [attackDiscovery]);
  const [items, setItems] = (0, _react2.useState)([{
    checked: !isShared ? 'on' : undefined,
    data: {
      description: i18n.ONLY_VISIBLE_TO_YOU
    },
    'data-test-subj': 'notShared',
    disabled: isShared,
    label: i18n.NOT_SHARED
  }, {
    checked: isShared ? 'on' : undefined,
    data: {
      description: i18n.VISIBLE_TO_YOUR_TEAM
    },
    'data-test-subj': 'shared',
    disabled: isShared,
    label: i18n.SHARED
  }]);
  const selectedLabel = (0, _react2.useMemo)(() => {
    const firstSelected = items.find(item => item.checked === 'on');
    return firstSelected != null ? firstSelected.label : items[0].label;
  }, [items]);
  const renderOption = (0, _react2.useCallback)(option => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          height: 53px;
          width: 132px;
        `,
    direction: "column",
    gutterSize: "none",
    justifyContent: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-weight: bold;
            `,
    "data-test-subj": "optionLabel",
    size: "s"
  }, option.label)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    "data-test-subj": "optionDescription",
    size: "s"
  }, option.description))), []);
  const button = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    "aria-label": i18n.VISIBILITY,
    color: "hollow",
    "data-test-subj": "sharedBadgeButton",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onBadgeButtonClick,
    onClickAriaLabel: i18n.SELECT_VISIBILITY_ARIA_LABEL
  }, selectedLabel), [onBadgeButtonClick, selectedLabel]);
  const {
    mutateAsync: attackDiscoveryBulk
  } = (0, _use_attack_discovery_bulk.useAttackDiscoveryBulk)();
  const onSelectableChange = (0, _react2.useCallback)(async newOptions => {
    setItems(newOptions);
    if ((0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery)) {
      const visibility = newOptions[0].checked === 'on' ? 'not_shared' : 'shared';
      await attackDiscoveryBulk({
        attackDiscoveryAlertsEnabled,
        ids: [attackDiscovery.id],
        visibility
      });

      // disable all options if the new visibility is 'shared'
      if (visibility === 'shared') {
        setItems(newOptions.map(item => ({
          ...item,
          disabled: true // prevent further changes
        })));
      }
      invalidateFindAttackDiscoveries();
    }
  }, [attackDiscovery, attackDiscoveryAlertsEnabled, attackDiscoveryBulk, invalidateFindAttackDiscoveries]);
  const allItemsDisabled = (0, _react2.useMemo)(() => items.every(item => item.disabled), [items]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: isPopoverOpen && allItemsDisabled ? i18n.THE_VISIBILITY_OF_SHARED : undefined,
    "data-test-subj": "sharedBadgeTooltip",
    position: "top"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    "data-test-subj": "sharedBadgePopover",
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.VISIBILITY,
    "data-test-subj": "sharedBadge",
    listProps: LIST_PROPS,
    options: items,
    onChange: onSelectableChange,
    renderOption: renderOption,
    singleSelection: true
  }, list => /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                width: 230px;
              `
  }, list))));
};
const SharedBadge = exports.SharedBadge = /*#__PURE__*/_react2.default.memo(SharedBadgeComponent);