"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionTitle = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react2 = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccordionTitleComponent = ({
  isLoading,
  replacements,
  showAnonymized = false,
  title
}) => {
  const titleWithReplacements = (0, _react2.useMemo)(() => (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
    messageContent: title,
    replacements: {
      ...replacements
    }
  }), [replacements, title]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "title",
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, isLoading ? /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonTitle, {
    css: (0, _react.css)`
              inline-size: 100%;
            `,
    "data-test-subj": "skeletonTitle",
    size: "xs"
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "titleText",
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement("h2", null, showAnonymized ? title : titleWithReplacements))));
};
AccordionTitleComponent.displayName = 'AccordionTitle';
const AccordionTitle = exports.AccordionTitle = /*#__PURE__*/_react2.default.memo(AccordionTitleComponent);