"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ID = exports.AttackDiscoveryPage = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _constants = require("../../../common/constants");
var _header_page = require("../../common/components/header_page");
var _use_invalid_filter_query = require("../../common/hooks/use_invalid_filter_query");
var _kibana = require("../../common/lib/kibana");
var _kuery = require("../../common/lib/kuery");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _header = require("./header");
var _helpers = require("./helpers");
var _loading_callout = require("./loading_callout");
var _deserialize_query = require("./local_storage/deserialize_query");
var _deserialize_filters = require("./local_storage/deserialize_filters");
var _page_title = require("./page_title");
var _results = require("./results");
var _settings_flyout = require("./settings_flyout");
var _constants2 = require("./settings_flyout/constants");
var _parse_filter_query = require("./settings_flyout/parse_filter_query");
var _containers = require("../../sourcerer/containers");
var _use_attack_discovery = require("./use_attack_discovery");
var _use_get_attack_discovery_generations = require("./use_get_attack_discovery_generations");
var _use_kibana_feature_flags = require("./use_kibana_feature_flags");
var _get_connector_name_from_id = require("./utils/get_connector_name_from_id");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'attackDiscoveryQuery';
const AttackDiscoveryPageComponent = () => {
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const {
    http,
    inferenceEnabled
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    inferenceEnabled
  });

  // for showing / hiding anonymized data:
  const [showAnonymized, setShowAnonymized] = (0, _react2.useState)(false);

  // showing / hiding the flyout:
  const [showFlyout, setShowFlyout] = (0, _react2.useState)(false);
  const [defaultSelectedTabId, setDefaultSelectedTabId] = (0, _react2.useState)(_constants2.SETTINGS_TAB_ID);
  const openFlyout = (0, _react2.useCallback)(tabId => {
    setDefaultSelectedTabId(tabId);
    setShowFlyout(true);
  }, []);

  // time selection:
  const [start, setStart] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.START_LOCAL_STORAGE_KEY}`, _elasticAssistantCommon.DEFAULT_START);
  const [end, setEnd] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.END_LOCAL_STORAGE_KEY}`, _elasticAssistantCommon.DEFAULT_END);

  // search bar query:
  const [query, setQuery] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.QUERY_LOCAL_STORAGE_KEY}`, (0, _helpers.getDefaultQuery)(), {
    raw: false,
    serializer: value => JSON.stringify(value),
    deserializer: _deserialize_query.deserializeQuery
  });

  // search bar filters:
  const [filters, setFilters] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.FILTERS_LOCAL_STORAGE_KEY}`, [], {
    raw: false,
    serializer: value => JSON.stringify(value),
    deserializer: _deserialize_filters.deserializeFilters
  });
  const onToggleShowAnonymized = (0, _react2.useCallback)(() => setShowAnonymized(current => !current), []);

  // get the last selected connector ID from local storage:
  const [localStorageAttackDiscoveryConnectorId, setLocalStorageAttackDiscoveryConnectorId] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_helpers.CONNECTOR_ID_LOCAL_STORAGE_KEY}`);
  const [localStorageAttackDiscoveryMaxAlerts, setLocalStorageAttackDiscoveryMaxAlerts] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.MAX_ALERTS_LOCAL_STORAGE_KEY}`, `${_elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS}`);
  const [connectorId, setConnectorId] = _react2.default.useState(localStorageAttackDiscoveryConnectorId);
  const connectorName = (0, _react2.useMemo)(() => (0, _get_connector_name_from_id.getConnectorNameFromId)({
    aiConnectors,
    connectorId
  }), [aiConnectors, connectorId]);

  // state for the connector loading in the background:
  const [loadingConnectorId, setLoadingConnectorId] = (0, _react2.useState)(null);
  const {
    alertsContextCount,
    approximateFutureTime,
    attackDiscoveries,
    didInitialFetch,
    failureReason,
    fetchAttackDiscoveries,
    generationIntervals,
    onCancel,
    isLoading,
    isLoadingPost,
    lastUpdated,
    replacements,
    stats
  } = (0, _use_attack_discovery.useAttackDiscovery)({
    connectorId,
    connectorName,
    setLoadingConnectorId,
    size: (0, _helpers.getSize)({
      defaultMaxAlerts: _elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS,
      localStorageAttackDiscoveryMaxAlerts
    })
  });

  // get last updated from the cached attack discoveries if it exists:
  const [selectedConnectorLastUpdated, setSelectedConnectorLastUpdated] = (0, _react2.useState)(lastUpdated !== null && lastUpdated !== void 0 ? lastUpdated : null);

  // get cached attack discoveries if they exist:
  const [selectedConnectorAttackDiscoveries, setSelectedConnectorAttackDiscoveries] = (0, _react2.useState)(attackDiscoveries !== null && attackDiscoveries !== void 0 ? attackDiscoveries : []);

  // get replacements from the cached attack discoveries if they exist:
  const [selectedConnectorReplacements, setSelectedConnectorReplacements] = (0, _react2.useState)(replacements !== null && replacements !== void 0 ? replacements : {});

  // the number of unique alerts in the attack discoveries:
  const alertsCount = (0, _react2.useMemo)(() => (0, _fp.uniq)(selectedConnectorAttackDiscoveries.flatMap(attackDiscovery => attackDiscovery.alertIds)).length, [selectedConnectorAttackDiscoveries]);

  /** The callback when users select a connector ID */
  const onConnectorIdSelected = (0, _react2.useCallback)(selectedConnectorId => {
    // update the connector ID in local storage:
    setConnectorId(selectedConnectorId);
    setLocalStorageAttackDiscoveryConnectorId(selectedConnectorId);
  }, [setLocalStorageAttackDiscoveryConnectorId]);

  // get connector intervals from generation intervals:
  const connectorIntervals = (0, _react2.useMemo)(() => generationIntervals !== null && generationIntervals !== void 0 ? generationIntervals : [], [generationIntervals]);
  const pageTitle = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_page_title.PageTitle, null), []);
  const {
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)();

  // filterQuery is the combined search bar query and filters in ES format:
  const [filterQuery, kqlError] = (0, _react2.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    queries: [query !== null && query !== void 0 ? query : (0, _helpers.getDefaultQuery)()],
    // <-- search bar query
    filters: filters !== null && filters !== void 0 ? filters : [] // <-- search bar filters
  }), [experimentalDataView, filters, oldSourcererDataView, query, uiSettings]);

  // renders a toast if the filter query is invalid:
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: ID,
    filterQuery,
    kqlError,
    query,
    startDate: start,
    endDate: end
  });
  const invalidateGetAttackDiscoveryGenerations = (0, _use_get_attack_discovery_generations.useInvalidateGetAttackDiscoveryGenerations)();
  const onGenerate = (0, _react2.useCallback)(async overrideOptions => {
    const size = (0, _helpers.getSize)({
      defaultMaxAlerts: _elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS,
      localStorageAttackDiscoveryMaxAlerts
    });
    const filter = (0, _parse_filter_query.parseFilterQuery)({
      filterQuery,
      kqlError
    });
    try {
      return await fetchAttackDiscoveries({
        end,
        filter,
        // <-- combined search bar query and filters
        size,
        start,
        overrideConnectorId: overrideOptions === null || overrideOptions === void 0 ? void 0 : overrideOptions.overrideConnectorId,
        overrideEnd: overrideOptions === null || overrideOptions === void 0 ? void 0 : overrideOptions.overrideEnd,
        overrideFilter: overrideOptions === null || overrideOptions === void 0 ? void 0 : overrideOptions.overrideFilter,
        overrideSize: overrideOptions === null || overrideOptions === void 0 ? void 0 : overrideOptions.overrideSize,
        overrideStart: overrideOptions === null || overrideOptions === void 0 ? void 0 : overrideOptions.overrideStart
      });
    } finally {
      invalidateGetAttackDiscoveryGenerations();
    }
  }, [end, fetchAttackDiscoveries, filterQuery, invalidateGetAttackDiscoveryGenerations, kqlError, localStorageAttackDiscoveryMaxAlerts, start]);
  (0, _react2.useEffect)(() => {
    setSelectedConnectorReplacements(replacements);
    setSelectedConnectorAttackDiscoveries(attackDiscoveries);
    setSelectedConnectorLastUpdated(lastUpdated);
  }, [attackDiscoveries, lastUpdated, replacements]);
  (0, _react2.useEffect)(() => {
    // If there is only one connector, set it as the selected connector
    if (aiConnectors != null && aiConnectors.length === 1) {
      setConnectorId(aiConnectors[0].id);
    } else if (aiConnectors != null && aiConnectors.length === 0) {
      // connectors have been removed, reset the connectorId and cached Attack discoveries
      setConnectorId(undefined);
      setSelectedConnectorAttackDiscoveries([]);
    }
  }, [aiConnectors]);
  const animatedLogo = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl"
  }), []);
  const connectorsAreConfigured = aiConnectors != null && aiConnectors.length > 0;
  const attackDiscoveriesCount = selectedConnectorAttackDiscoveries.length;
  const onClose = (0, _react2.useCallback)(() => setShowFlyout(false), []);
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        display: flex;
        flex-direction: column;
        flex: 1 1 auto;
      `,
    "data-test-subj": "fullHeightContainer"
  }, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "attackDiscoveryPage"
  }, /*#__PURE__*/_react2.default.createElement(_header_page.HeaderPage, {
    border: true,
    title: pageTitle
  }, /*#__PURE__*/_react2.default.createElement(_header.Header, {
    connectorId: connectorId,
    connectorsAreConfigured: connectorsAreConfigured
    // disable header actions before post request has completed
    ,
    isDisabledActions: isLoadingPost,
    isLoading: isLoading,
    onCancel: onCancel,
    onConnectorIdSelected: onConnectorIdSelected,
    onGenerate: onGenerate,
    openFlyout: openFlyout,
    stats: stats,
    showFlyout: showFlyout
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: attackDiscoveryAlertsEnabled ? 's' : 'm'
  })), !attackDiscoveryAlertsEnabled && connectorsAreConfigured && connectorId != null && !didInitialFetch ? /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "animatedLogo",
    icon: animatedLogo
  }) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, !attackDiscoveryAlertsEnabled && (0, _helpers.showLoading)({
    attackDiscoveriesCount,
    connectorId,
    isLoading: isLoading || isLoadingPost,
    loadingConnectorId
  }) ? /*#__PURE__*/_react2.default.createElement(_loading_callout.LoadingCallout, {
    alertsContextCount: alertsContextCount,
    approximateFutureTime: approximateFutureTime,
    connectorIntervals: connectorIntervals,
    end: end,
    localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
    start: start
  }) : /*#__PURE__*/_react2.default.createElement(_results.Results, {
    aiConnectors: aiConnectors,
    alertsContextCount: alertsContextCount,
    alertsCount: alertsCount,
    approximateFutureTime: approximateFutureTime,
    attackDiscoveriesCount: attackDiscoveriesCount,
    connectorId: connectorId,
    connectorIntervals: connectorIntervals,
    end: end,
    failureReason: failureReason,
    isLoading: isLoading,
    isLoadingPost: isLoadingPost,
    localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
    loadingConnectorId: loadingConnectorId,
    onGenerate: onGenerate,
    onToggleShowAnonymized: onToggleShowAnonymized,
    selectedConnectorAttackDiscoveries: selectedConnectorAttackDiscoveries,
    selectedConnectorLastUpdated: selectedConnectorLastUpdated,
    selectedConnectorReplacements: selectedConnectorReplacements,
    showAnonymized: showAnonymized,
    start: start,
    stats: stats
  }), showFlyout && /*#__PURE__*/_react2.default.createElement(_settings_flyout.SettingsFlyout, {
    connectorId: connectorId,
    defaultSelectedTabId: defaultSelectedTabId,
    end: end,
    filters: filters,
    onClose: onClose,
    onConnectorIdSelected: onConnectorIdSelected,
    onGenerate: onGenerate,
    query: query,
    setEnd: setEnd,
    setFilters: setFilters,
    setQuery: setQuery,
    setStart: setStart,
    start: start,
    stats: stats,
    localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
    setLocalStorageAttackDiscoveryMaxAlerts: setLocalStorageAttackDiscoveryMaxAlerts
  })), /*#__PURE__*/_react2.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.attackDiscovery
  })));
};
AttackDiscoveryPageComponent.displayName = 'AttackDiscoveryPage';
const AttackDiscoveryPage = exports.AttackDiscoveryPage = /*#__PURE__*/_react2.default.memo(AttackDiscoveryPageComponent);