"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMigrateConversationsFromLocalStorage = exports.MigrateConversationsFromLocalStorage = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _create_conversation = require("./create_conversation");
var _kibana = require("../../common/lib/kibana");
var _use_license = require("../../common/hooks/use_license");
var _use_assistant_availability = require("../use_assistant_availability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMigrateConversationsFromLocalStorage = () => {
  const hasEnterpriseLicense = _use_license.licenseService.isEnterprise();
  const assistantAvailability = (0, _use_assistant_availability.useAssistantAvailability)();
  const {
    http,
    notifications,
    storage
  } = (0, _kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    const migrateConversationsFromLocalStorage = (0, _lodash.once)(async () => {
      if (hasEnterpriseLicense && assistantAvailability.isAssistantEnabled && assistantAvailability.hasAssistantPrivilege) {
        const conversationsExist = await (0, _elasticAssistant.getUserConversationsExist)({
          http
        });
        if (!conversationsExist) {
          await (0, _create_conversation.createConversations)(notifications, http, storage);
        }
      }
    });
    migrateConversationsFromLocalStorage();
  }, [assistantAvailability.hasAssistantPrivilege, assistantAvailability.isAssistantEnabled, hasEnterpriseLicense, http, notifications, storage]);
};
exports.useMigrateConversationsFromLocalStorage = useMigrateConversationsFromLocalStorage;
const MigrateConversationsFromLocalStorage = () => {
  useMigrateConversationsFromLocalStorage();
  return null;
};
exports.MigrateConversationsFromLocalStorage = MigrateConversationsFromLocalStorage;