"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateRuleMigrationRule = exports.RuleMigrationTranslationStats = exports.RuleMigrationTranslationResultEnum = exports.RuleMigrationTranslationResult = exports.RuleMigrationTaskStatusEnum = exports.RuleMigrationTaskStatus = exports.RuleMigrationTaskStats = exports.RuleMigrationTaskExecutionSettings = exports.RuleMigrationStatusEnum = exports.RuleMigrationStatus = exports.RuleMigrationRuleData = exports.RuleMigrationRule = exports.RuleMigrationRetryFilterEnum = exports.RuleMigrationRetryFilter = exports.RuleMigrationResourceTypeEnum = exports.RuleMigrationResourceType = exports.RuleMigrationResourceData = exports.RuleMigrationResourceContent = exports.RuleMigrationResourceBase = exports.RuleMigrationResource = exports.RuleMigrationLastExecution = exports.RuleMigrationIntegrationStats = exports.RuleMigrationData = exports.RuleMigrationComments = exports.RuleMigrationComment = exports.RuleMigrationAllIntegrationsStats = exports.RuleMigration = exports.PrebuiltRuleVersion = exports.OriginalRuleVendor = exports.OriginalRuleAnnotations = exports.OriginalRule = exports.ElasticRulePartial = exports.ElasticRule = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("../../api/model/primitives.gen");
var _rule_schemas = require("../../api/detection_engine/model/rule_schema/rule_schemas.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: SIEM Rule Migration components
 *   version: not applicable
 */

/**
 * The original rule vendor identifier.
 */

const OriginalRuleVendor = exports.OriginalRuleVendor = _zod.z.literal('splunk');

/**
 * The original rule annotations containing additional information.
 */

const OriginalRuleAnnotations = exports.OriginalRuleAnnotations = _zod.z.object({
  /**
   * The original rule Mitre Attack IDs.
   */
  mitre_attack: _zod.z.array(_zod.z.string()).optional()
}).catchall(_zod.z.unknown());

/**
 * The original rule to migrate.
 */

const OriginalRule = exports.OriginalRule = _zod.z.object({
  /**
   * The original rule id.
   */
  id: _primitives.NonEmptyString,
  /**
   * The original rule vendor identifier.
   */
  vendor: OriginalRuleVendor,
  /**
   * The original rule name.
   */
  title: _primitives.NonEmptyString,
  /**
   * The original rule description.
   */
  description: _zod.z.string(),
  /**
   * The original rule query.
   */
  query: _zod.z.string().min(1),
  /**
   * The original rule query language.
   */
  query_language: _zod.z.string(),
  /**
   * The original rule annotations containing additional information.
   */
  annotations: OriginalRuleAnnotations.optional(),
  /**
   * The original rule's severity or some representation of it.
   */
  severity: _zod.z.string().optional()
});

/**
 * The migrated elastic rule.
 */

const ElasticRule = exports.ElasticRule = _zod.z.object({
  /**
   * The migrated rule title.
   */
  title: _zod.z.string(),
  /**
   * The migrated rule description.
   */
  description: _zod.z.string().optional(),
  /**
   * The migrated rule severity.
   */
  severity: _zod.z.string().optional(),
  /**
   * The migrated rule risk_score value, integer between 0 and 100.
   */
  risk_score: _zod.z.number().optional(),
  /**
   * The translated elastic query.
   */
  query: _zod.z.string().optional(),
  /**
   * The translated elastic query language.
   */
  query_language: _zod.z.literal('esql').optional(),
  /**
   * The Elastic prebuilt rule id matched.
   */
  prebuilt_rule_id: _primitives.NonEmptyString.nullable().optional(),
  /**
   * The IDs of the Elastic integrations suggested to be installed for this rule.
   */
  integration_ids: _zod.z.array(_zod.z.string()).optional(),
  /**
   * The Elastic rule id installed as a result.
   */
  id: _primitives.NonEmptyString.optional()
});

/**
 * The partial version of the migrated elastic rule.
 */

const ElasticRulePartial = exports.ElasticRulePartial = ElasticRule.partial();

/**
 * The prebuilt rule version.
 */

const PrebuiltRuleVersion = exports.PrebuiltRuleVersion = _zod.z.object({
  /**
   * The latest available version of prebuilt rule.
   */
  target: _rule_schemas.RuleResponse,
  /**
   * The currently installed version of prebuilt rule.
   */
  current: _rule_schemas.RuleResponse.optional()
});

/**
 * The last execution of the rule migration task.
 */

const RuleMigrationLastExecution = exports.RuleMigrationLastExecution = _zod.z.object({
  /**
   * The moment the last execution started.
   */
  started_at: _zod.z.string().optional(),
  /**
   * The moment the last execution finished.
   */
  finished_at: _zod.z.string().nullable().optional(),
  /**
   * The connector ID used for the last execution.
   */
  connector_id: _zod.z.string().optional(),
  /**
   * The error message if the last execution failed.
   */
  error: _zod.z.string().nullable().optional(),
  /**
   * Indicates if the last execution was stopped by the user.
   */
  is_stopped: _zod.z.boolean().optional(),
  /**
   * Indicates if the last execution skipped pre-built rule matching.
   */
  skip_prebuilt_rules_matching: _zod.z.boolean().optional()
});

/**
 * The rule migration object ( without Id ) with its settings.
 */

const RuleMigrationData = exports.RuleMigrationData = _zod.z.object({
  /**
   * The user profile ID of the user who created the migration.
   */
  created_by: _primitives.NonEmptyString,
  /**
   * The moment migration was created
   */
  created_at: _primitives.NonEmptyString,
  /**
   * The last execution of the rule migration task.
   */
  last_execution: RuleMigrationLastExecution.optional()
});

/**
 * The rule migration object with its settings.
 */

const RuleMigration = exports.RuleMigration = _zod.z.object({
  /**
   * The rule migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The rule migration name
   */
  name: _primitives.NonEmptyString
}).merge(RuleMigrationData);

/**
 * The rule translation result.
 */

const RuleMigrationTranslationResult = exports.RuleMigrationTranslationResult = _zod.z.enum(['full', 'partial', 'untranslatable']);
const RuleMigrationTranslationResultEnum = exports.RuleMigrationTranslationResultEnum = RuleMigrationTranslationResult.enum;

/**
 * The status of each rule migration.
 */

const RuleMigrationStatus = exports.RuleMigrationStatus = _zod.z.enum(['pending', 'processing', 'completed', 'failed']);
const RuleMigrationStatusEnum = exports.RuleMigrationStatusEnum = RuleMigrationStatus.enum;

/**
 * The comment for the migration
 */

const RuleMigrationComment = exports.RuleMigrationComment = _zod.z.object({
  /**
   * The comment for the migration
   */
  message: _zod.z.string(),
  /**
   * The moment of creation
   */
  created_at: _zod.z.string(),
  /**
   * The user profile ID of the user who created the comment or `assistant` if it was generated by the LLM
   */
  created_by: _zod.z.string()
});

/**
 * The comments for the migration including a summary from the LLM in markdown.
 */

const RuleMigrationComments = exports.RuleMigrationComments = _zod.z.array(RuleMigrationComment);

/**
 * The rule migration document object.
 */

const RuleMigrationRuleData = exports.RuleMigrationRuleData = _zod.z.object({
  /**
   * The moment of creation
   */
  '@timestamp': _zod.z.string(),
  /**
   * The migration id.
   */
  migration_id: _primitives.NonEmptyString,
  /**
   * The user profile ID of the user who created the migration.
   */
  created_by: _primitives.NonEmptyString,
  /**
   * The original rule to migrate.
   */
  original_rule: OriginalRule,
  /**
   * The migrated elastic rule.
   */
  elastic_rule: ElasticRule.optional(),
  /**
   * The rule translation result.
   */
  translation_result: RuleMigrationTranslationResult.optional(),
  /**
   * The status of the rule migration process.
   */
  status: RuleMigrationStatus.default('pending'),
  /**
   * The comments for the migration including a summary from the LLM in markdown.
   */
  comments: RuleMigrationComments.optional(),
  /**
   * The moment of the last update
   */
  updated_at: _zod.z.string().optional(),
  /**
   * The user who last updated the migration
   */
  updated_by: _zod.z.string().optional()
});

/**
 * The rule migration document object.
 */

const RuleMigrationRule = exports.RuleMigrationRule = _zod.z.object({
  /**
   * The rule migration id
   */
  id: _primitives.NonEmptyString
}).merge(RuleMigrationRuleData);

/**
 * The status of the migration task.
 */

const RuleMigrationTaskStatus = exports.RuleMigrationTaskStatus = _zod.z.enum(['ready', 'running', 'stopped', 'finished', 'interrupted']);
const RuleMigrationTaskStatusEnum = exports.RuleMigrationTaskStatusEnum = RuleMigrationTaskStatus.enum;

/**
 * The rule migration task stats object.
 */

const RuleMigrationTaskStats = exports.RuleMigrationTaskStats = _zod.z.object({
  /**
   * The migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The migration name
   */
  name: _primitives.NonEmptyString,
  /**
   * Indicates if the migration task status.
   */
  status: RuleMigrationTaskStatus,
  /**
   * The rules migration stats.
   */
  rules: _zod.z.object({
    /**
     * The total number of rules to migrate.
     */
    total: _zod.z.number().int(),
    /**
     * The number of rules that are pending migration.
     */
    pending: _zod.z.number().int(),
    /**
     * The number of rules that are being migrated.
     */
    processing: _zod.z.number().int(),
    /**
     * The number of rules that have been migrated successfully.
     */
    completed: _zod.z.number().int(),
    /**
     * The number of rules that have failed migration.
     */
    failed: _zod.z.number().int()
  }),
  /**
   * The moment the migration was created.
   */
  created_at: _zod.z.string(),
  /**
   * The moment of the last update.
   */
  last_updated_at: _zod.z.string(),
  /**
   * The last execution of the migration task.
   */
  last_execution: RuleMigrationLastExecution.optional()
});

/**
 * The rule migration translation stats object.
 */

const RuleMigrationTranslationStats = exports.RuleMigrationTranslationStats = _zod.z.object({
  /**
   * The migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The rules migration translation stats.
   */
  rules: _zod.z.object({
    /**
     * The total number of rules in the migration.
     */
    total: _zod.z.number().int(),
    /**
     * The number of rules that have been successfully translated.
     */
    success: _zod.z.object({
      /**
       * The total number of rules that have been successfully translated.
       */
      total: _zod.z.number().int(),
      /**
       * The translation results
       */
      result: _zod.z.object({
        /**
         * The number of rules that have been fully translated.
         */
        full: _zod.z.number().int(),
        /**
         * The number of rules that have been partially translated.
         */
        partial: _zod.z.number().int(),
        /**
         * The number of rules that could not be translated.
         */
        untranslatable: _zod.z.number().int()
      }),
      /**
       * The number of rules that have been successfully translated and can be installed.
       */
      installable: _zod.z.number().int(),
      /**
       * The number of rules that have been successfully translated and matched Elastic prebuilt rules.
       */
      prebuilt: _zod.z.number().int()
    }),
    /**
     * The number of rules that have failed translation.
     */
    failed: _zod.z.number().int()
  })
});

/**
 * The rule migration data object for rule update operation
 */

const UpdateRuleMigrationRule = exports.UpdateRuleMigrationRule = _zod.z.object({
  /**
   * The rule migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The migrated elastic rule attributes to update.
   */
  elastic_rule: ElasticRulePartial.optional(),
  /**
   * The comments for the migration including a summary from the LLM in markdown.
   */
  comments: RuleMigrationComments.optional()
});

/**
 * Indicates the filter to retry the migrations rules translation
 */

const RuleMigrationRetryFilter = exports.RuleMigrationRetryFilter = _zod.z.enum(['failed', 'not_fully_translated']);
const RuleMigrationRetryFilterEnum = exports.RuleMigrationRetryFilterEnum = RuleMigrationRetryFilter.enum;

/**
 * The migration rules integration stats object.
 */

const RuleMigrationIntegrationStats = exports.RuleMigrationIntegrationStats = _zod.z.object({
  /**
   * The integration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The number of rules that are associated with the integration.
   */
  total_rules: _zod.z.number().int()
});

/**
 * The integrations stats objects of all the rule of all the migrations.
 */

const RuleMigrationAllIntegrationsStats = exports.RuleMigrationAllIntegrationsStats = _zod.z.array(RuleMigrationIntegrationStats);

/**
 * The type of the rule migration resource.
 */

const RuleMigrationResourceType = exports.RuleMigrationResourceType = _zod.z.enum(['macro', 'lookup']);
const RuleMigrationResourceTypeEnum = exports.RuleMigrationResourceTypeEnum = RuleMigrationResourceType.enum;

/**
 * The rule migration resource basic information.
 */

const RuleMigrationResourceBase = exports.RuleMigrationResourceBase = _zod.z.object({
  type: RuleMigrationResourceType,
  /**
   * The resource name identifier.
   */
  name: _zod.z.string()
});
const RuleMigrationResourceContent = exports.RuleMigrationResourceContent = _zod.z.object({
  /**
   * The resource content value. Can be an empty string.
   */
  content: _zod.z.string(),
  /**
   * The resource arbitrary metadata.
   */
  metadata: _zod.z.object({}).optional()
});

/**
 * The rule migration resource data.
 */

const RuleMigrationResourceData = exports.RuleMigrationResourceData = RuleMigrationResourceBase.merge(RuleMigrationResourceContent);

/**
 * The rule migration resource document object.
 */

const RuleMigrationResource = exports.RuleMigrationResource = RuleMigrationResourceBase.merge(RuleMigrationResourceContent.partial()).merge(_zod.z.object({
  /**
   * The rule resource migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The migration id
   */
  migration_id: _primitives.NonEmptyString,
  /**
   * The moment of the last update
   */
  updated_at: _zod.z.string().optional(),
  /**
   * The user who last updated the resource
   */
  updated_by: _zod.z.string().optional()
}));

/**
 * The rule migration task execution settings.
 */

const RuleMigrationTaskExecutionSettings = exports.RuleMigrationTaskExecutionSettings = _zod.z.object({
  /**
   * The connector ID used for the last execution.
   */
  connector_id: _zod.z.string(),
  /**
   * Indicates if the current execution should skip matching prebuilt rules.
   */
  skip_prebuilt_rules_matching: _zod.z.boolean().optional()
});