"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListEntitiesResponse = exports.ListEntitiesRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common = require("../common.gen");
var _common2 = require("./common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Entities List Schema
 *   version: 2023-10-31
 */

const ListEntitiesRequestQuery = exports.ListEntitiesRequestQuery = _zod.z.object({
  sort_field: _zod.z.string().optional(),
  sort_order: _zod.z.enum(['asc', 'desc']).optional(),
  page: _zod.z.coerce.number().int().min(1).optional(),
  per_page: _zod.z.coerce.number().int().min(1).max(10000).optional(),
  /**
   * An ES query to filter by.
   */
  filterQuery: _zod.z.string().optional(),
  entity_types: (0, _zodHelpers.ArrayFromString)(_common.EntityType)
});
const ListEntitiesResponse = exports.ListEntitiesResponse = _zod.z.object({
  records: _zod.z.array(_common2.Entity),
  page: _zod.z.number().int().min(1),
  per_page: _zod.z.number().int().min(1).max(1000),
  total: _zod.z.number().int().min(0),
  inspect: _common.InspectQuery.optional()
});