"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMachineLearningNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _i18n_strings = require("../i18n_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMachineLearningNavigationTree = () => ({
  id: _constants.SecurityGroupName.machineLearning,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.machineLearning].title,
  renderAs: 'panelOpener',
  children: [{
    breadcrumbStatus: 'hidden',
    children: [{
      link: 'ml:overview',
      title: _i18n_strings.i18nStrings.ml.overview
    }, {
      link: 'ml:dataVisualizer',
      title: _i18n_strings.i18nStrings.ml.dataVisualizer
    }]
  }, {
    title: _i18n_strings.i18nStrings.ml.anomalyDetection.title,
    breadcrumbStatus: 'hidden',
    children: [{
      link: 'ml:anomalyExplorer',
      title: _i18n_strings.i18nStrings.ml.anomalyDetection.anomalyExplorer
    }, {
      link: 'ml:singleMetricViewer',
      title: _i18n_strings.i18nStrings.ml.anomalyDetection.singleMetricViewer
    }]
  }, {
    title: _i18n_strings.i18nStrings.ml.dataFrameAnalytics.title,
    breadcrumbStatus: 'hidden',
    children: [{
      link: 'ml:resultExplorer',
      title: _i18n_strings.i18nStrings.ml.dataFrameAnalytics.resultExplorer
    }, {
      link: 'ml:analyticsMap',
      title: _i18n_strings.i18nStrings.ml.dataFrameAnalytics.analyticsMap
    }]
  }, {
    title: _i18n_strings.i18nStrings.ml.aiopsLabs.title,
    breadcrumbStatus: 'hidden',
    children: [{
      link: 'ml:logRateAnalysis',
      title: _i18n_strings.i18nStrings.ml.aiopsLabs.logRateAnalysis
    }, {
      link: 'ml:logPatternAnalysis',
      title: _i18n_strings.i18nStrings.ml.aiopsLabs.logPatternAnalysis
    }, {
      link: 'ml:changePointDetections',
      title: _i18n_strings.i18nStrings.ml.aiopsLabs.changePointDetection
    }]
  }]
});
exports.createMachineLearningNavigationTree = createMachineLearningNavigationTree;